/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.client.TransportConnector;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.dns.DnsResolver;
import rocks.xmpp.dns.TxtRecord;
import rocks.xmpp.websocket.net.client.WebSocketConnectionConfiguration;

abstract class AbstractWebSocketConnector
implements TransportConnector<WebSocketConnectionConfiguration> {
    protected AbstractWebSocketConnector() {
    }

    protected URI getUri(XmppSession xmppSession, WebSocketConnectionConfiguration configuration) throws URISyntaxException {
        int targetPort;
        String protocol;
        String string = protocol = configuration.getChannelEncryption() == ChannelEncryption.DIRECT ? "wss" : "ws";
        int n = configuration.getPort() > 0 ? configuration.getPort() : (targetPort = configuration.getChannelEncryption() == ChannelEncryption.DIRECT ? 5281 : 5280);
        if (configuration.getHostname() != null) {
            return new URI(protocol, null, configuration.getHostname(), targetPort, configuration.getPath(), null, null);
        }
        if (xmppSession.getDomain() != null) {
            String resolvedUrl = AbstractWebSocketConnector.findWebSocketEndpoint(xmppSession.getDomain().toString(), xmppSession.getConfiguration().getNameServer(), configuration.getConnectTimeout());
            if (resolvedUrl != null) {
                return new URI(resolvedUrl);
            }
            return new URI(protocol, null, xmppSession.getDomain().toString(), targetPort, configuration.getPath(), null, null);
        }
        throw new IllegalStateException("Neither an URL nor a domain given for a WebSocket connection.");
    }

    private static String findWebSocketEndpoint(String xmppServiceDomain, String nameServer, long timeout) {
        try {
            List txtRecords = DnsResolver.resolveTXT((CharSequence)xmppServiceDomain, (String)nameServer, (long)timeout);
            for (TxtRecord txtRecord : txtRecords) {
                Map attributes = txtRecord.asAttributes();
                String url = (String)attributes.get("_xmpp-client-websocket");
                if (url == null) continue;
                return url;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }
}

