/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net.client;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.ReaderInterceptorChain;
import rocks.xmpp.core.net.WriterInterceptorChain;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.websocket.net.client.AbstractWebSocketClientConnection;
import rocks.xmpp.websocket.net.client.WebSocketConnectionConfiguration;

final class HttpClientWebSocketConnection
extends AbstractWebSocketClientConnection
implements WebSocket.Listener {
    private final StringBuilder receivedMessaged = new StringBuilder();
    private WebSocket webSocket;
    private CompletableFuture<?> accumulatedMessage = new CompletableFuture();

    HttpClientWebSocketConnection(WebSocketConnectionConfiguration connectionConfiguration, URI uri, XmppSession xmppSession, CompletableFuture<Void> closeFuture) {
        super(connectionConfiguration, uri, xmppSession, closeFuture);
    }

    public final CompletionStage<Void> write(StreamElement streamElement) {
        CompletionStage completionStage;
        WriterInterceptorChain writerInterceptorChain = new WriterInterceptorChain((Iterable)this.writerInterceptors, (Session)this.xmppSession, (Connection)this);
        StringWriter writer = new StringWriter();
        try {
            writerInterceptorChain.proceed(streamElement, (Writer)writer);
            completionStage = this.webSocket.sendText(((Object)writer).toString(), true).thenRun(() -> {});
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return CompletableFuture.failedStage(e);
            }
        }
        ((Writer)writer).close();
        return completionStage;
    }

    public final void flush() {
    }

    @Override
    public final void onOpen(WebSocket webSocket) {
        this.webSocket = webSocket;
        webSocket.request(1L);
    }

    @Override
    public final CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        this.receivedMessaged.append(data);
        webSocket.request(1L);
        if (last) {
            ReaderInterceptorChain readerInterceptorChain = new ReaderInterceptorChain((Iterable)this.readerInterceptors, (Session)this.xmppSession, (Connection)this);
            try {
                readerInterceptorChain.proceed((Reader)new StringReader(this.receivedMessaged.toString()), arg_0 -> ((HttpClientWebSocketConnection)this).handleElement(arg_0));
            }
            catch (Exception e) {
                this.xmppSession.notifyException((Throwable)e);
            }
            this.receivedMessaged.setLength(0);
            this.receivedMessaged.trimToSize();
            this.accumulatedMessage.complete(null);
            CompletableFuture<?> cf = this.accumulatedMessage;
            this.accumulatedMessage = new CompletableFuture();
            return cf;
        }
        return this.accumulatedMessage;
    }

    @Override
    public final CompletionStage<?> onPong(WebSocket webSocket, ByteBuffer message) {
        this.pongReceived(message);
        webSocket.request(1L);
        return null;
    }

    protected final CompletionStage<Void> closeConnection() {
        return this.webSocket.sendClose(1000, "").thenRun(this::doCloseConnection);
    }

    @Override
    public final void sendPing(ByteBuffer message) {
        this.webSocket.sendPing(message);
    }
}

