/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.util.concurrent.CompletableFuture;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.client.ClientConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.extensions.httpbind.HttpClientConnector;
import rocks.xmpp.websocket.net.client.AbstractWebSocketConnector;
import rocks.xmpp.websocket.net.client.HttpClientWebSocketConnection;
import rocks.xmpp.websocket.net.client.WebSocketConnectionConfiguration;

public final class HttpClientWebSocketConnector
extends AbstractWebSocketConnector {
    public final CompletableFuture<Connection> connect(XmppSession xmppSession, WebSocketConnectionConfiguration configuration, SessionOpen sessionOpen) {
        URI uri;
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        try {
            uri = this.getUri(xmppSession, configuration);
        }
        catch (URISyntaxException e) {
            return CompletableFuture.failedFuture(e);
        }
        HttpClientWebSocketConnection webSocketClientConnection = new HttpClientWebSocketConnection(configuration, uri, xmppSession, closeFuture);
        HttpClient.Builder builder = HttpClientConnector.newHttpClientBuilder((ClientConnectionConfiguration)configuration);
        return ((CompletableFuture)builder.build().newWebSocketBuilder().subprotocols("xmpp", new String[0]).buildAsync(uri, webSocketClientConnection).thenCompose(webSocket -> webSocketClientConnection.open(sessionOpen))).thenApply(aVoid -> webSocketClientConnection);
    }
}

