/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.websocket.net.JakartaWebSocketConnection;
import rocks.xmpp.websocket.net.client.AbstractWebSocketClientConnection;
import rocks.xmpp.websocket.net.client.WebSocketConnectionConfiguration;

final class JakartaWebSocketClientConnection
extends AbstractWebSocketClientConnection {
    private final JakartaWebSocketConnection jakartaWebSocketConnection;
    private final Session session;

    JakartaWebSocketClientConnection(Session session, CompletableFuture<Void> closeFuture, XmppSession xmppSession, WebSocketConnectionConfiguration connectionConfiguration, URI uri) {
        super(connectionConfiguration, uri, xmppSession, closeFuture);
        this.session = session;
        this.jakartaWebSocketConnection = new JakartaWebSocketConnection(session, (ConnectionConfiguration)connectionConfiguration, (StreamHandler)xmppSession, arg_0 -> ((XmppSession)xmppSession).notifyException(arg_0), closeFuture, arg_0 -> ((JakartaWebSocketClientConnection)this).handleElement(arg_0));
        session.addMessageHandler((MessageHandler)new PongHandler());
    }

    protected CompletionStage<Void> closeConnection() {
        return this.jakartaWebSocketConnection.closeConnection();
    }

    public CompletionStage<Void> write(StreamElement streamElement) {
        return this.jakartaWebSocketConnection.write(streamElement);
    }

    public void flush() {
        this.jakartaWebSocketConnection.flush();
    }

    @Override
    protected void sendPing(ByteBuffer message) throws IOException {
        this.session.getBasicRemote().sendPing(message);
    }

    private final class PongHandler
    implements MessageHandler.Whole<PongMessage> {
        private PongHandler() {
        }

        public final void onMessage(PongMessage message) {
            JakartaWebSocketClientConnection.this.pongReceived(message.getApplicationData());
        }
    }
}

