/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.SessionException;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.client.SslEngineConfigurator;
import org.glassfish.tyrus.client.ThreadPoolConfig;
import org.glassfish.tyrus.container.jdk.client.JdkClientContainer;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.websocket.codec.XmppWebSocketDecoder;
import rocks.xmpp.websocket.codec.XmppWebSocketEncoder;
import rocks.xmpp.websocket.net.client.AbstractWebSocketConnector;
import rocks.xmpp.websocket.net.client.JakartaWebSocketClientConnection;
import rocks.xmpp.websocket.net.client.WebSocketConnectionConfiguration;

public final class JakartaWebSocketConnector
extends AbstractWebSocketConnector {
    public final CompletableFuture<Connection> connect(final XmppSession xmppSession, final WebSocketConnectionConfiguration configuration, final SessionOpen sessionOpen) {
        Proxy proxy;
        final CompletableFuture closeFuture = new CompletableFuture();
        final AtomicBoolean handshakeSucceeded = new AtomicBoolean();
        ClientEndpointConfig clientEndpointConfig = ClientEndpointConfig.Builder.create().encoders(Collections.singletonList(XmppWebSocketEncoder.class)).decoders(Collections.singletonList(XmppWebSocketDecoder.class)).preferredSubprotocols(Collections.singletonList("xmpp")).configurator(new ClientEndpointConfig.Configurator(){

            public void afterResponse(HandshakeResponse response) {
                List responseHeader = (List)response.getHeaders().get("Sec-WebSocket-Protocol");
                if (responseHeader != null && responseHeader.contains("xmpp")) {
                    handshakeSucceeded.set(true);
                }
            }
        }).build();
        clientEndpointConfig.getUserProperties().put("marshaller", () -> ((XmppSession)xmppSession).createMarshaller());
        clientEndpointConfig.getUserProperties().put("unmarshaller", () -> ((XmppSession)xmppSession).createUnmarshaller());
        if (xmppSession.getDebugger() != null) {
            clientEndpointConfig.getUserProperties().put("onWrite", xmppSession.getWriterInterceptors());
            clientEndpointConfig.getUserProperties().put("onRead", Collections.singleton(xmppSession.getDebugger()));
        }
        clientEndpointConfig.getUserProperties().put("xmlOutputFactory", xmppSession.getConfiguration().getXmlOutputFactory());
        clientEndpointConfig.getUserProperties().put("xmlInputFactory", xmppSession.getConfiguration().getXmlInputFactory());
        ClientManager client = ClientManager.createClient((String)JdkClientContainer.class.getName());
        if (configuration.getSSLContext() != null) {
            SslEngineConfigurator sslEngineConfigurator = new SslEngineConfigurator(configuration.getSSLContext());
            client.getProperties().put("org.glassfish.tyrus.client.sslEngineConfigurator", sslEngineConfigurator);
            sslEngineConfigurator.setHostnameVerifier(configuration.getHostnameVerifier());
        }
        ThreadPoolConfig config = ThreadPoolConfig.defaultConfig();
        config.setThreadFactory(xmppSession.getConfiguration().getThreadFactory("WebSocket Client"));
        client.getProperties().put("org.glassfish.tyrus.client.workerThreadPoolConfig", config);
        int connectTimeout = configuration.getConnectTimeout();
        if (connectTimeout > 0) {
            client.getProperties().put("org.glassfish.tyrus.client.ClientManager.ContainerTimeout", connectTimeout);
        }
        if ((proxy = configuration.getProxy()) != null && proxy.type() == Proxy.Type.HTTP) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
            client.getProperties().put("org.glassfish.tyrus.client.proxy", "http://" + inetSocketAddress.getHostName() + ":" + inetSocketAddress.getPort());
        }
        final CompletableFuture<Connection> connectionFuture = new CompletableFuture<Connection>();
        try {
            final URI uri = this.getUri(xmppSession, configuration);
            client.asyncConnectToServer(new Endpoint(){

                public void onOpen(Session session, EndpointConfig config) {
                    if (!handshakeSucceeded.get()) {
                        try {
                            String msg = "Server did not respond with 'Sec-WebSocket-Protocol' header with value 'xmpp'.";
                            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, msg));
                        }
                        catch (IOException e) {
                            xmppSession.notifyException((Throwable)e);
                        }
                    } else {
                        JakartaWebSocketClientConnection webSocketConnection = new JakartaWebSocketClientConnection(session, closeFuture, xmppSession, configuration, uri);
                        config.getUserProperties().put("session", xmppSession);
                        config.getUserProperties().put("connection", webSocketConnection);
                        webSocketConnection.open(sessionOpen).whenComplete((aVoid, throwable) -> {
                            if (throwable == null) {
                                connectionFuture.complete(webSocketConnection);
                            } else {
                                connectionFuture.completeExceptionally((Throwable)throwable);
                            }
                        });
                    }
                }

                public void onError(Session session, Throwable t) {
                    connectionFuture.completeExceptionally(t);
                }

                public void onClose(Session session, CloseReason closeReason) {
                    if (closeReason.getCloseCode() != CloseReason.CloseCodes.NORMAL_CLOSURE) {
                        closeFuture.completeExceptionally((Throwable)new SessionException(closeReason.toString(), null, session));
                    }
                    closeFuture.complete(null);
                }
            }, clientEndpointConfig, uri);
        }
        catch (Exception e) {
            connectionFuture.completeExceptionally(e);
        }
        return connectionFuture;
    }
}

