/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net.client;

import java.net.Proxy;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.client.ClientConnectionConfiguration;
import rocks.xmpp.core.net.client.TransportConnector;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.websocket.net.client.HttpClientWebSocketConnector;

public final class WebSocketConnectionConfiguration
extends ClientConnectionConfiguration {
    private static volatile WebSocketConnectionConfiguration defaultConfiguration;
    private final String path;
    private final Duration pingInterval;
    private final TransportConnector<WebSocketConnectionConfiguration> connector;

    private WebSocketConnectionConfiguration(Builder builder) {
        super((ClientConnectionConfiguration.Builder)builder);
        this.path = builder.path;
        this.pingInterval = builder.pingInterval;
        this.connector = builder.getConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebSocketConnectionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<WebSocketConnectionConfiguration> clazz = WebSocketConnectionConfiguration.class;
        synchronized (WebSocketConnectionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = WebSocketConnectionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(WebSocketConnectionConfiguration configuration) {
        Class<WebSocketConnectionConfiguration> clazz = WebSocketConnectionConfiguration.class;
        synchronized (WebSocketConnectionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public final String getPath() {
        return this.path;
    }

    public final Duration getPingInterval() {
        return this.pingInterval;
    }

    public final CompletableFuture<Connection> createConnection(XmppSession xmppSession, SessionOpen sessionOpen) {
        if (this.connector == null) {
            return new HttpClientWebSocketConnector().connect(xmppSession, this, sessionOpen);
        }
        return this.connector.connect(xmppSession, (ClientConnectionConfiguration)this, sessionOpen);
    }

    public final String toString() {
        return "WebSocket connection configuration: " + (this.getChannelEncryption() == ChannelEncryption.DIRECT ? "wss" : "ws") + "://" + super.toString() + this.path;
    }

    public static final class Builder
    extends ClientConnectionConfiguration.Builder<Builder, WebSocketConnectionConfiguration> {
        private String path;
        private Duration pingInterval;

        private Builder() {
            this.path("/ws");
        }

        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Builder pingInterval(Duration pingInterval) {
            this.pingInterval = pingInterval;
            return this;
        }

        protected final Builder self() {
            return this;
        }

        public final WebSocketConnectionConfiguration build() {
            if (this.proxy != null && this.proxy.type() != Proxy.Type.HTTP && this.proxy.type() != Proxy.Type.DIRECT) {
                throw new UnsupportedOperationException("Non-HTTP proxies are not supported by WebSockets.");
            }
            if (this.channelEncryption != null && this.channelEncryption != ChannelEncryption.DISABLED && this.channelEncryption != ChannelEncryption.DIRECT) {
                throw new IllegalArgumentException("WebSocket connections only support ChannelEncryption.DIRECT (wss)or ChannelEncryption.DISABLED (ws).");
            }
            return new WebSocketConnectionConfiguration(this);
        }
    }
}

