/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.codec;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfig;
import javax.xml.stream.XMLInputFactory;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.ReaderInterceptor;
import rocks.xmpp.core.net.ReaderInterceptorChain;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.util.XmppStreamDecoder;

public final class XmppWebSocketDecoder
implements Decoder.TextStream<StreamElement> {
    private Session session;
    private Connection connection;
    private Iterable<ReaderInterceptor> interceptors;

    public final StreamElement decode(Reader reader) throws DecodeException, IOException {
        try {
            ReaderInterceptorChain readerInterceptorChain = new ReaderInterceptorChain(this.interceptors, this.session, this.connection);
            ArrayList out = new ArrayList();
            readerInterceptorChain.proceed(reader, out::add);
            if (!out.isEmpty()) {
                return (StreamElement)out.get(0);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecodeException(reader.toString(), e.getMessage(), (Throwable)e);
        }
        throw new IOException("Could not decode an element from the reader");
    }

    public final void init(EndpointConfig config) {
        this.session = (Session)config.getUserProperties().get("session");
        this.connection = (Connection)config.getUserProperties().get("connection");
        XMLInputFactory xmlInputFactory = (XMLInputFactory)config.getUserProperties().get("xmlInputFactory");
        if (xmlInputFactory == null) {
            xmlInputFactory = XMLInputFactory.newFactory();
        }
        Supplier unmarshaller = (Supplier)config.getUserProperties().get("unmarshaller");
        ArrayList<ReaderInterceptor> readerInterceptors = new ArrayList<ReaderInterceptor>();
        Iterable additionalInterceptors = (Iterable)config.getUserProperties().get("onRead");
        if (additionalInterceptors != null) {
            additionalInterceptors.forEach(readerInterceptors::add);
        }
        readerInterceptors.add((ReaderInterceptor)new XmppStreamDecoder(xmlInputFactory, unmarshaller, ""));
        this.interceptors = readerInterceptors;
    }

    public final void destroy() {
        this.interceptors = null;
    }

    public static final class UserProperties {
        public static final String UNMARSHALLER = "unmarshaller";
        public static final String XML_INPUT_FACTORY = "xmlInputFactory";
        public static final String ON_READ = "onRead";
        public static final String CONNECTION = "connection";
        public static final String SESSION = "session";

        private UserProperties() {
        }
    }
}

