/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.codec;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfig;
import javax.xml.stream.XMLOutputFactory;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.WriterInterceptor;
import rocks.xmpp.core.net.WriterInterceptorChain;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.util.XmppStreamEncoder;

public final class XmppWebSocketEncoder
implements Encoder.TextStream<StreamElement> {
    private Session session;
    private Connection connection;
    private Iterable<WriterInterceptor> interceptors;

    public final void encode(StreamElement object, Writer writer) throws EncodeException, IOException {
        try {
            WriterInterceptorChain writerInterceptorChain = new WriterInterceptorChain(this.interceptors, this.session, this.connection);
            writerInterceptorChain.proceed(object, writer);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncodeException((Object)object, e.getMessage(), (Throwable)e);
        }
    }

    public final void init(EndpointConfig config) {
        this.session = (Session)config.getUserProperties().get("session");
        this.connection = (Connection)config.getUserProperties().get("connection");
        XMLOutputFactory xmlOutputFactory = (XMLOutputFactory)config.getUserProperties().get("xmlOutputFactory");
        if (xmlOutputFactory == null) {
            xmlOutputFactory = XMLOutputFactory.newFactory();
        }
        Supplier marshaller = (Supplier)config.getUserProperties().get("marshaller");
        ArrayList<WriterInterceptor> writerInterceptors = new ArrayList<WriterInterceptor>();
        Iterable additionalInterceptors = (Iterable)config.getUserProperties().get("onWrite");
        if (additionalInterceptors != null) {
            additionalInterceptors.forEach(writerInterceptors::add);
        }
        writerInterceptors.add((WriterInterceptor)new XmppStreamEncoder(xmlOutputFactory, marshaller, streamElement -> streamElement instanceof StreamFeatures || streamElement instanceof StreamError));
        this.interceptors = writerInterceptors;
    }

    public final void destroy() {
        this.interceptors = null;
    }

    public static final class UserProperties {
        public static final String MARSHALLER = "marshaller";
        public static final String XML_OUTPUT_FACTORY = "xmlOutputFactory";
        public static final String ON_WRITE = "onWrite";
        public static final String CONNECTION = "connection";
        public static final String SESSION = "session";

        private UserProperties() {
        }
    }
}

