/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.websocket.net.WebSocketConnection;

public final class JakartaWebSocketConnection
extends WebSocketConnection {
    private final Session session;

    public JakartaWebSocketConnection(Session session, ConnectionConfiguration connectionConfiguration, StreamHandler streamHandler, Consumer<Throwable> onException, CompletionStage<Void> closeFuture, MessageHandler.Whole<StreamElement> messageHandler) {
        super(connectionConfiguration, streamHandler, onException, closeFuture);
        this.session = session;
        session.addMessageHandler(StreamElement.class, messageHandler != null ? messageHandler : arg_0 -> ((JakartaWebSocketConnection)this).handleElement(arg_0));
    }

    protected void restartStream() {
    }

    public final CompletionStage<Void> closeConnection() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.session.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public final InetSocketAddress getRemoteAddress() {
        return InetSocketAddress.createUnresolved(this.session.getRequestURI().getHost(), this.session.getRequestURI().getPort());
    }

    public final CompletableFuture<Void> write(StreamElement streamElement) {
        CompletableFuture<Void> sendFuture = new CompletableFuture<Void>();
        this.session.getAsyncRemote().sendObject((Object)streamElement, result -> {
            if (result.isOK()) {
                sendFuture.complete(null);
            } else {
                sendFuture.completeExceptionally(result.getException());
            }
        });
        return sendFuture;
    }

    public final void flush() {
        try {
            this.session.getAsyncRemote().flushBatch();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("WebSocket connection at ").append(this.session.getRequestURI());
        String streamId = this.getStreamId();
        if (streamId != null) {
            sb.append(" (").append(streamId).append(')');
        }
        return sb.toString();
    }
}

