/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net;

import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import rocks.xmpp.core.net.AbstractConnection;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.websocket.model.Close;
import rocks.xmpp.websocket.model.Open;

public abstract class WebSocketConnection
extends AbstractConnection {
    private final CompletionStage<Void> closeFuture;
    protected SessionOpen sessionOpen;

    protected WebSocketConnection(ConnectionConfiguration connectionConfiguration, StreamHandler streamHandler, Consumer<Throwable> onException, CompletionStage<Void> closeFuture) {
        super(connectionConfiguration, streamHandler, onException);
        this.closeFuture = closeFuture;
        this.closeFuture().whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                onException.accept((Throwable)throwable);
            }
        });
    }

    public final CompletionStage<Void> open(SessionOpen sessionOpen) {
        this.sessionOpen = sessionOpen;
        return this.send(new Open(sessionOpen.getTo(), sessionOpen.getFrom(), sessionOpen.getId(), sessionOpen.getLanguage()));
    }

    public final CompletionStage<Void> send(StreamElement streamElement) {
        return this.write(streamElement).thenRun(() -> ((WebSocketConnection)this).flush());
    }

    public final boolean isSecure() {
        return this.getConfiguration().getChannelEncryption() == ChannelEncryption.DIRECT;
    }

    public final CompletionStage<Void> closeFuture() {
        return this.closeFuture;
    }

    protected final CompletionStage<Void> closeStream() {
        return this.send(new Close());
    }
}

