/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket;

import java.net.URI;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.websocket.model.Close;
import rocks.xmpp.websocket.model.Open;

public class WebSocketTest
extends XmlTest {
    protected WebSocketTest() throws JAXBException, XMLStreamException {
        super(new Class[]{Open.class, Close.class});
    }

    @Test
    public void unmarshalOpen() throws XMLStreamException, JAXBException {
        Open open = (Open)this.unmarshal("<open xmlns=\"urn:ietf:params:xml:ns:xmpp-framing\" version=\"1.0\" to=\"test\" xml:lang=\"en\"></open>", Open.class);
        Assert.assertEquals((Object)open.getLanguage(), (Object)Locale.ENGLISH);
        Assert.assertEquals((Object)open.getTo(), (Object)Jid.ofDomain((CharSequence)"test"));
    }

    @Test
    public void unmarshalClose() throws XMLStreamException, JAXBException {
        Close close = (Close)this.unmarshal("<close xmlns=\"urn:ietf:params:xml:ns:xmpp-framing\" version=\"1.0\" see-other-uri=\"wss://otherendpoint.example/xmpp-bind\"></close>", Close.class);
        Assert.assertEquals((Object)close.getUri(), (Object)URI.create("wss://otherendpoint.example/xmpp-bind"));
    }

    @Test
    public void marshalOpen() throws XMLStreamException, JAXBException {
        Open open = new Open(Jid.of((CharSequence)"test"), Locale.ENGLISH);
        Assert.assertEquals((String)this.marshal(open), (String)"<open xmlns=\"urn:ietf:params:xml:ns:xmpp-framing\" version=\"1.0\" to=\"test\" xml:lang=\"en\"></open>");
    }

    @Test
    public void marshalClose() throws XMLStreamException, JAXBException {
        Close close = new Close(URI.create("wss://otherendpoint.example/xmpp-bind"));
        Assert.assertEquals((String)this.marshal(close), (String)"<close xmlns=\"urn:ietf:params:xml:ns:xmpp-framing\" version=\"1.0\" see-other-uri=\"wss://otherendpoint.example/xmpp-bind\"></close>");
    }
}

