/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.HandshakeResponse;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.SessionException;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.client.SslEngineConfigurator;
import org.glassfish.tyrus.container.jdk.client.JdkClientContainer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.dns.DnsResolver;
import rocks.xmpp.dns.TxtRecord;
import rocks.xmpp.extensions.sm.StreamManager;
import rocks.xmpp.extensions.sm.model.StreamManagement;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.websocket.WebSocketConnectionConfiguration;
import rocks.xmpp.websocket.model.Close;
import rocks.xmpp.websocket.model.Open;

public final class WebSocketConnection
extends Connection {
    private final StreamFeaturesManager streamFeaturesManager;
    private final StreamManager streamManager;
    private final XmppDebugger debugger;
    private final WebSocketConnectionConfiguration connectionConfiguration;
    private final Lock lock = new ReentrantLock();
    private final Condition closeReceived = this.lock.newCondition();
    private final Set<String> pings = new CopyOnWriteArraySet<String>();
    private boolean closedByServer;
    private URI uri;
    private Session session;
    private String streamId;
    private Throwable exception;
    private ScheduledThreadPoolExecutor executorService;

    WebSocketConnection(XmppSession xmppSession, WebSocketConnectionConfiguration connectionConfiguration) {
        super(xmppSession, (ConnectionConfiguration)connectionConfiguration);
        this.connectionConfiguration = connectionConfiguration;
        this.debugger = xmppSession.getDebugger();
        this.streamFeaturesManager = (StreamFeaturesManager)xmppSession.getManager(StreamFeaturesManager.class);
        this.streamManager = (StreamManager)xmppSession.getManager(StreamManager.class);
    }

    private static String findWebSocketEndpoint(String xmppServiceDomain, long timeout) {
        try {
            List txtRecords = DnsResolver.resolveTXT((CharSequence)xmppServiceDomain, (long)timeout);
            for (TxtRecord txtRecord : txtRecords) {
                Map attributes = txtRecord.asAttributes();
                String url = (String)attributes.get("_xmpp-client-websocket");
                if (url == null) continue;
                return url;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    protected final void restartStream() {
        this.send(new Open(this.xmppSession.getDomain(), this.xmppSession.getConfiguration().getLanguage()));
    }

    public final synchronized CompletableFuture<Void> send(StreamElement streamElement) {
        return CompletableFuture.runAsync(() -> {
            try (StringWriter writer = new StringWriter();
                 XMLStreamWriter xmlStreamWriter = null;){
                xmlStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLStreamWriter(writer), null);
                this.xmppSession.createMarshaller().marshal((Object)streamElement, xmlStreamWriter);
                xmlStreamWriter.flush();
                String xml = writer.toString();
                if (streamElement instanceof Stanza) {
                    this.streamManager.markUnacknowledged((Stanza)streamElement);
                }
                this.session.getBasicRemote().sendText(xml);
                if (streamElement instanceof Stanza && this.streamManager.isActive() && this.streamManager.getRequestStrategy().test((Stanza)streamElement)) {
                    this.send((StreamElement)StreamManagement.REQUEST);
                }
                if (this.debugger != null) {
                    this.debugger.writeStanza(xml, (Object)streamElement);
                }
            }
            catch (Exception e) {
                this.xmppSession.notifyException((Throwable)e);
                throw new CompletionException(e);
            }
        }, this.executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(Jid from, String namespace, final Consumer<Jid> onStreamOpened) throws IOException {
        try {
            Proxy proxy;
            int connectTimeout;
            URI path;
            WebSocketConnection webSocketConnection = this;
            synchronized (webSocketConnection) {
                if (this.session != null && this.session.isOpen()) {
                    return;
                }
                this.exception = null;
                this.closedByServer = false;
                this.executorService = new ScheduledThreadPoolExecutor(1);
                this.executorService.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                if (this.connectionConfiguration.getPingInterval() != null && !this.connectionConfiguration.getPingInterval().isNegative() && !this.connectionConfiguration.getPingInterval().isZero()) {
                    this.executorService.scheduleAtFixedRate(() -> {
                        WebSocketConnection webSocketConnection = this;
                        synchronized (webSocketConnection) {
                            try {
                                String uuid;
                                if (this.session != null && this.session.isOpen() && this.pings.add(uuid = UUID.randomUUID().toString())) {
                                    this.session.getBasicRemote().sendPing(ByteBuffer.wrap(uuid.getBytes(StandardCharsets.UTF_8)));
                                    this.executorService.schedule(() -> {
                                        if (this.pings.remove(uuid)) {
                                            this.xmppSession.notifyException((Throwable)new XmppException("No WebSocket pong received in time."));
                                        }
                                    }, this.xmppSession.getConfiguration().getDefaultResponseTimeout().toMillis(), TimeUnit.MILLISECONDS);
                                }
                            }
                            catch (IOException e) {
                                this.xmppSession.notifyException((Throwable)e);
                            }
                        }
                    }, 0L, this.connectionConfiguration.getPingInterval().toMillis(), TimeUnit.MILLISECONDS);
                }
                if (this.uri == null) {
                    int targetPort;
                    String protocol;
                    String string = protocol = this.connectionConfiguration.isSecure() ? "wss" : "ws";
                    int n = this.getPort() > 0 ? this.getPort() : (targetPort = this.connectionConfiguration.isSecure() ? 5281 : 5280);
                    if (this.getHostname() != null) {
                        this.uri = new URI(protocol, null, this.getHostname(), targetPort, this.connectionConfiguration.getPath(), null, null);
                    } else if (this.xmppSession.getDomain() != null) {
                        String resolvedUrl = WebSocketConnection.findWebSocketEndpoint(this.xmppSession.getDomain().toString(), this.connectionConfiguration.getConnectTimeout());
                        this.uri = resolvedUrl != null ? new URI(resolvedUrl) : new URI(protocol, null, this.xmppSession.getDomain().toString(), targetPort, this.connectionConfiguration.getPath(), null, null);
                        this.port = this.uri.getPort();
                        this.hostname = this.uri.getHost();
                    } else {
                        throw new IllegalStateException("Neither an URL nor a domain given for a WebSocket connection.");
                    }
                }
                path = this.uri;
            }
            final AtomicBoolean handshakeSucceeded = new AtomicBoolean();
            ClientEndpointConfig clientEndpointConfig = ClientEndpointConfig.Builder.create().configurator(new ClientEndpointConfig.Configurator(){

                public void beforeRequest(Map<String, List<String>> headers) {
                    headers.put("Sec-WebSocket-Protocol", Collections.singletonList("xmpp"));
                }

                public void afterResponse(HandshakeResponse response) {
                    List responseHeader = (List)response.getHeaders().get("Sec-WebSocket-Protocol");
                    if (responseHeader != null && responseHeader.contains("xmpp")) {
                        handshakeSucceeded.set(true);
                    }
                }
            }).build();
            ClientManager client = ClientManager.createClient((String)JdkClientContainer.class.getName());
            if (this.connectionConfiguration.getSSLContext() != null) {
                SslEngineConfigurator sslEngineConfigurator = new SslEngineConfigurator(this.connectionConfiguration.getSSLContext());
                client.getProperties().put("org.glassfish.tyrus.client.sslEngineConfigurator", sslEngineConfigurator);
                sslEngineConfigurator.setHostnameVerifier(this.connectionConfiguration.getHostnameVerifier());
            }
            if ((connectTimeout = this.connectionConfiguration.getConnectTimeout()) > 0) {
                client.getProperties().put("org.glassfish.tyrus.client.ClientManager.ContainerTimeout", connectTimeout);
            }
            if ((proxy = this.connectionConfiguration.getProxy()) != null && proxy.type() == Proxy.Type.HTTP) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
                client.getProperties().put("org.glassfish.tyrus.client.proxy", "http://" + inetSocketAddress.getHostName() + ':' + inetSocketAddress.getPort());
            }
            this.streamFeaturesManager.addFeatureNegotiator((StreamFeatureNegotiator)this.streamManager);
            this.streamManager.reset();
            Session session = client.connectToServer(new Endpoint(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onOpen(Session session, EndpointConfig config) {
                    WebSocketConnection webSocketConnection = WebSocketConnection.this;
                    synchronized (webSocketConnection) {
                        WebSocketConnection.this.session = session;
                        if (!handshakeSucceeded.get()) {
                            try {
                                String msg = "Server response did not include 'Sec-WebSocket-Protocol' header with value 'xmpp'.";
                                WebSocketConnection.this.exception = new IOException(msg);
                                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, msg));
                                return;
                            }
                            catch (IOException e) {
                                WebSocketConnection.this.exception.addSuppressed(e);
                            }
                        }
                    }
                    session.addMessageHandler(String.class, message -> {
                        try {
                            Object element = WebSocketConnection.this.xmppSession.createUnmarshaller().unmarshal((Reader)new StringReader((String)message));
                            if (WebSocketConnection.this.debugger != null) {
                                WebSocketConnection.this.debugger.readStanza(message, element);
                            }
                            if (element instanceof Open) {
                                Open open = (Open)element;
                                onStreamOpened.accept(open.getFrom());
                                WebSocketConnection webSocketConnection = WebSocketConnection.this;
                                synchronized (webSocketConnection) {
                                    WebSocketConnection.this.streamId = open.getId();
                                }
                            }
                            if (element instanceof Close) {
                                WebSocketConnection webSocketConnection = WebSocketConnection.this;
                                synchronized (webSocketConnection) {
                                    WebSocketConnection.this.closedByServer = true;
                                }
                                WebSocketConnection.this.close();
                                WebSocketConnection.this.lock.lock();
                                try {
                                    WebSocketConnection.this.closeReceived.signalAll();
                                }
                                finally {
                                    WebSocketConnection.this.lock.unlock();
                                }
                            }
                            if (WebSocketConnection.this.xmppSession.handleElement(element)) {
                                WebSocketConnection.this.restartStream();
                            }
                        }
                        catch (Exception e) {
                            WebSocketConnection.this.xmppSession.notifyException((Throwable)e);
                        }
                    });
                    session.addMessageHandler((MessageHandler)new PongHandler());
                    WebSocketConnection.this.restartStream();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onError(Session session, Throwable t) {
                    WebSocketConnection webSocketConnection = WebSocketConnection.this;
                    synchronized (webSocketConnection) {
                        WebSocketConnection.this.exception = t;
                    }
                    WebSocketConnection.this.xmppSession.notifyException(t);
                }

                public void onClose(Session session, CloseReason closeReason) {
                    if (closeReason.getCloseCode() != CloseReason.CloseCodes.NORMAL_CLOSURE) {
                        WebSocketConnection.this.xmppSession.notifyException((Throwable)new SessionException(closeReason.toString(), null, session));
                    }
                }
            }, clientEndpointConfig, path);
            if (!session.isOpen()) {
                throw new IOException("Session could not be opened.");
            }
            WebSocketConnection webSocketConnection2 = this;
            synchronized (webSocketConnection2) {
                if (this.exception != null) {
                    throw this.exception instanceof IOException ? (IOException)this.exception : new IOException(this.exception);
                }
            }
        }
        catch (URISyntaxException | DeploymentException e) {
            throw new IOException(e);
        }
    }

    public final boolean isSecure() {
        return this.connectionConfiguration.isSecure();
    }

    public final synchronized String getStreamId() {
        return this.streamId;
    }

    public final boolean isUsingAcknowledgements() {
        return this.streamManager.isActive();
    }

    public final synchronized void close() throws Exception {
        block7: {
            try {
                if (this.session == null || !this.session.isOpen()) break block7;
                this.send(new Close());
                this.lock.lock();
                try {
                    if (!this.closedByServer) {
                        this.closeReceived.await(500L, TimeUnit.MILLISECONDS);
                    }
                }
                finally {
                    this.lock.unlock();
                }
                this.executorService.shutdown();
                this.executorService = null;
                this.session.close();
                this.pings.clear();
            }
            finally {
                this.streamFeaturesManager.removeFeatureNegotiator((StreamFeatureNegotiator)this.streamManager);
            }
        }
    }

    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder("WebSocket connection");
        if (this.uri != null) {
            sb.append(" to ").append(this.uri);
        }
        if (this.streamId != null) {
            sb.append(" (").append(this.streamId).append(')');
        }
        if (this.from != null) {
            sb.append(", from: ").append((CharSequence)this.from);
        }
        return sb.toString();
    }

    private final class PongHandler
    implements MessageHandler.Whole<PongMessage> {
        private PongHandler() {
        }

        public final void onMessage(PongMessage message) {
            byte[] bytes = new byte[message.getApplicationData().limit()];
            message.getApplicationData().get(bytes);
            WebSocketConnection.this.pings.remove(new String(bytes, StandardCharsets.UTF_8));
        }
    }
}

