/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket;

import java.net.Proxy;
import java.time.Duration;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.websocket.WebSocketConnection;

public final class WebSocketConnectionConfiguration
extends ConnectionConfiguration {
    private static volatile WebSocketConnectionConfiguration defaultConfiguration;
    private final String path;
    private final Duration pingInterval;

    private WebSocketConnectionConfiguration(Builder builder) {
        super((ConnectionConfiguration.Builder)builder);
        this.path = builder.path;
        this.pingInterval = builder.pingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebSocketConnectionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<WebSocketConnectionConfiguration> clazz = WebSocketConnectionConfiguration.class;
        synchronized (WebSocketConnectionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = WebSocketConnectionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(WebSocketConnectionConfiguration configuration) {
        Class<WebSocketConnectionConfiguration> clazz = WebSocketConnectionConfiguration.class;
        synchronized (WebSocketConnectionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public final String getPath() {
        return this.path;
    }

    public final Duration getPingInterval() {
        return this.pingInterval;
    }

    public final Connection createConnection(XmppSession xmppSession) {
        return new WebSocketConnection(xmppSession, this);
    }

    public final String toString() {
        return "WebSocket connection configuration: " + (this.isSecure() ? "wss" : "ws") + "://" + super.toString() + this.path;
    }

    public static final class Builder
    extends ConnectionConfiguration.Builder<Builder> {
        private String path;
        private Duration pingInterval;

        private Builder() {
            this.path("/ws/");
        }

        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Builder pingInterval(Duration pingInterval) {
            this.pingInterval = pingInterval;
            return this;
        }

        protected final Builder self() {
            return this;
        }

        public final WebSocketConnectionConfiguration build() {
            if (this.proxy != null && this.proxy.type() != Proxy.Type.HTTP && this.proxy.type() != Proxy.Type.DIRECT) {
                throw new UnsupportedOperationException("Non-HTTP proxies are not supported by WebSockets.");
            }
            return new WebSocketConnectionConfiguration(this);
        }
    }
}

