/*
 * Decompiled with CFR 0.152.
 */
package rodeo.password.pgencheck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rodeo.password.pgencheck.AbstractFactory;
import rodeo.password.pgencheck.PasswordCheckError;
import rodeo.password.pgencheck.PasswordCheckStatus;
import rodeo.password.pgencheck.PasswordData;

public final class PasswordChecker
extends PasswordData {
    private final int minLength;
    private final int maxLength;

    private PasswordChecker(int minLength, int maxLength, List<String> charGroups, List<Integer> groupMinCounts, List<Integer> groupMaxCounts) {
        super(charGroups, groupMinCounts, groupMaxCounts);
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public static Factory factory() {
        return new Factory();
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean quickCheck(String password) {
        if (password.length() < this.minLength) {
            return false;
        }
        if (password.length() > this.maxLength) {
            return false;
        }
        for (int codePoint : password.codePoints().toArray()) {
            if (this.getAllChars().indexOf(codePoint) != -1) continue;
            return false;
        }
        Map<Integer, Integer> charCounts = this.getCharacterTypeCounts(password);
        for (int i = 0; i < this.groupMinCounts().size(); ++i) {
            int count = charCounts.get(i);
            if (count >= this.groupMinCounts().get(i) && (this.groupMaxCounts().get(i) == 0 || count <= this.groupMaxCounts().get(i))) continue;
            return false;
        }
        return true;
    }

    private Map<Integer, Integer> getCharacterTypeCounts(String password) {
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.charGroups().size(); ++i) {
            counts.put(i, 0);
        }
        password.codePoints().forEach(codePoint -> {
            for (int i = 0; i < this.charGroups().size(); ++i) {
                if (this.charGroups().get(i).indexOf(codePoint) == -1) continue;
                counts.put(i, (Integer)counts.get(i) + 1);
            }
        });
        return counts;
    }

    public PasswordCheckStatus check(String password) {
        if (password.length() < this.minLength) {
            return PasswordCheckStatus.TOO_SHORT;
        }
        if (password.length() > this.maxLength) {
            return PasswordCheckStatus.TOO_LONG;
        }
        for (int codePoint : password.codePoints().toArray()) {
            if (this.getAllChars().indexOf(codePoint) != -1) continue;
            return PasswordCheckStatus.ILLEGAL_CHARACTER;
        }
        Map<Integer, Integer> charCounts = this.getCharacterTypeCounts(password);
        for (int i = 0; i < this.groupMinCounts().size(); ++i) {
            int count = charCounts.get(i);
            if (count < this.groupMinCounts().get(i)) {
                return PasswordCheckStatus.NOT_ENOUGH_OF_CHARACTER_GROUP;
            }
            if (this.groupMaxCounts().get(i) <= 0 || count <= this.groupMaxCounts().get(i)) continue;
            return PasswordCheckStatus.TOO_MANY_OF_CHARACTER_GROUP;
        }
        return PasswordCheckStatus.OK;
    }

    public List<PasswordCheckError> fullCheck(String password) {
        ArrayList<PasswordCheckError> errors = new ArrayList<PasswordCheckError>();
        if (password.length() < this.minLength) {
            errors.add(PasswordCheckError.tooShort());
        }
        if (password.length() > this.maxLength) {
            errors.add(PasswordCheckError.tooLong());
        }
        password.codePoints().forEach(codePoint -> {
            if (this.getAllChars().indexOf(codePoint) == -1) {
                errors.add(PasswordCheckError.illegalCharacter(codePoint));
            }
        });
        Map<Integer, Integer> charCounts = this.getCharacterTypeCounts(password);
        for (int i = 0; i < this.groupMinCounts().size(); ++i) {
            int count = charCounts.get(i);
            if (count < this.groupMinCounts().get(i)) {
                errors.add(PasswordCheckError.notEnoughOfCharacterType(i, this.charGroups().get(i), this.groupMinCounts().get(i), charCounts.get(i)));
            }
            if (this.groupMaxCounts().get(i) <= 0 || count <= this.groupMaxCounts().get(i)) continue;
            errors.add(PasswordCheckError.tooManyOfCharacterType(i, this.charGroups().get(i), this.groupMaxCounts().get(i), charCounts.get(i)));
        }
        return errors;
    }

    public static final class Factory
    extends AbstractFactory<Factory> {
        private int minLength = 16;
        private int maxLength = 64;

        private Factory() {
        }

        public Factory setMinMaxLength(int minLength, int maxLength) {
            if (minLength < 1) {
                throw new IllegalArgumentException("Minimum character count must be at least 1. Value received: " + minLength);
            }
            if (maxLength < minLength) {
                throw new IllegalArgumentException("Maximum character count cannot be smaller than minimum count: " + maxLength + " < " + minLength);
            }
            this.minLength = minLength;
            this.maxLength = maxLength;
            return this;
        }

        public PasswordChecker create() {
            if (this.charGroups().isEmpty()) {
                throw new IllegalStateException("At least one charset must be specified before a PasswordChecker can be created");
            }
            if (this.isSetCountSumLargerThanMaxPasswordCount()) {
                throw new IllegalStateException("Conditions can never be fulfilled. Not enough characters in password to satisfy all conditions, assuming character groups are disjoint");
            }
            return new PasswordChecker(this.minLength, this.maxLength, this.charGroupsCopy(), this.groupMinCountsCopy(), this.groupMaxCountsCopy());
        }

        private boolean isSetCountSumLargerThanMaxPasswordCount() {
            int sum = 0;
            for (int count : this.groupMinCounts()) {
                sum += count;
            }
            return sum > this.maxLength;
        }

        @Override
        Factory getThis() {
            return this;
        }

        @Override
        public Factory addCharGroup(String charGroup) {
            return (Factory)super.addCharGroup(charGroup);
        }

        @Override
        public Factory addCharGroup(String charGroup, int minCount) {
            return (Factory)super.addCharGroup(charGroup, minCount, 0);
        }

        @Override
        public Factory addCharGroup(String charGroup, int minCount, int maxCount) {
            return (Factory)super.addCharGroup(charGroup, minCount, maxCount);
        }

        @Override
        public Factory disallowDuplicateCharacters(boolean disallowDuplicateCharacters) {
            return (Factory)super.disallowDuplicateCharacters(disallowDuplicateCharacters);
        }
    }
}

