/*
 * Decompiled with CFR 0.152.
 */
package rodeo.password.pgencheck;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractFactory<F extends AbstractFactory<F>> {
    private final List<String> charGroups = new ArrayList<String>();
    private final List<Integer> groupMinCounts = new ArrayList<Integer>();
    private final List<Integer> groupMaxCounts = new ArrayList<Integer>();
    private boolean disallowDuplicateCharacters = true;

    AbstractFactory() {
    }

    List<String> charGroups() {
        return this.charGroups;
    }

    List<Integer> groupMinCounts() {
        return this.groupMinCounts;
    }

    List<Integer> groupMaxCounts() {
        return this.groupMaxCounts;
    }

    List<String> charGroupsCopy() {
        return new ArrayList<String>(this.charGroups);
    }

    List<Integer> groupMinCountsCopy() {
        return new ArrayList<Integer>(this.groupMinCounts);
    }

    List<Integer> groupMaxCountsCopy() {
        return new ArrayList<Integer>(this.groupMaxCounts);
    }

    F addCharGroup(String charGroup) {
        return this.addCharGroup(charGroup, 0);
    }

    F addCharGroup(String charGroup, int minCount) {
        return this.addCharGroup(charGroup, minCount, 0);
    }

    F addCharGroup(String charGroup, int minCount, int maxCount) {
        if (charGroup == null) {
            throw new NullPointerException("Character group cannot be null");
        }
        if (charGroup.isEmpty()) {
            throw new IllegalArgumentException("Character group cannot be empty and must contain at least one character");
        }
        if (minCount < 0) {
            throw new IllegalArgumentException("Minimum character count cannot be negative. Value received: " + minCount);
        }
        if (maxCount < 0) {
            throw new IllegalArgumentException("Maximum character count cannot be negative. Value received: " + minCount);
        }
        if (maxCount != 0 && maxCount < minCount) {
            throw new IllegalArgumentException("Maximum character count cannot be smaller than minimum count: " + maxCount + " < " + minCount);
        }
        if (this.disallowDuplicateCharacters) {
            String duplicates = this.getGroupDuplicates(charGroup);
            if (!duplicates.isEmpty()) {
                throw new IllegalArgumentException("Character group contains duplicates. This is not allowed. Duplicates: " + duplicates);
            }
            duplicates = this.getInterGroupDuplicates(charGroup);
            if (!duplicates.isEmpty()) {
                throw new IllegalArgumentException("Character group duplicates some characters from an other group. This is not allowed. Duplicates: " + duplicates);
            }
        }
        this.charGroups.add(charGroup);
        this.groupMinCounts.add(minCount);
        this.groupMaxCounts.add(maxCount);
        return this.getThis();
    }

    private String getGroupDuplicates(String charGroup) {
        LinkedHashMap<Integer, Integer> counts = new LinkedHashMap<Integer, Integer>();
        for (int codePoint : charGroup.codePoints().toArray()) {
            counts.merge(codePoint, 1, Integer::sum);
        }
        StringBuilder duplicates = new StringBuilder();
        for (Map.Entry codePointCount : counts.entrySet()) {
            if ((Integer)codePointCount.getValue() <= 1) continue;
            duplicates.appendCodePoint((Integer)codePointCount.getKey());
        }
        return duplicates.toString();
    }

    private String getInterGroupDuplicates(String charGroup) {
        StringBuilder duplicates = new StringBuilder();
        for (String group : this.charGroups) {
            for (int codePoint : charGroup.codePoints().toArray()) {
                if (group.indexOf(codePoint) == -1) continue;
                duplicates.appendCodePoint(codePoint);
            }
        }
        return duplicates.toString();
    }

    F disallowDuplicateCharacters(boolean disallowDuplicateCharacters) {
        this.disallowDuplicateCharacters = disallowDuplicateCharacters;
        return this.getThis();
    }

    abstract F getThis();
}

