/*
 * Decompiled with CFR 0.152.
 */
package rodeo.password.pgencheck;

import rodeo.password.pgencheck.BadCountForCharacterTypeError;
import rodeo.password.pgencheck.IllegalCharacterError;
import rodeo.password.pgencheck.PasswordCheckStatus;

public class PasswordCheckError {
    private final PasswordCheckStatus errorType;

    PasswordCheckError(PasswordCheckStatus errorType) {
        this.errorType = errorType;
    }

    static PasswordCheckError tooShort() {
        return new PasswordCheckError(PasswordCheckStatus.TOO_SHORT);
    }

    static PasswordCheckError tooLong() {
        return new PasswordCheckError(PasswordCheckStatus.TOO_LONG);
    }

    static PasswordCheckError illegalCharacter(int illegalCharacter) {
        return new IllegalCharacterError(illegalCharacter);
    }

    static PasswordCheckError notEnoughOfCharacterType(int missingCharacterListIndex, String missingCharacterList, int expectedCount, int actualCount) {
        return new BadCountForCharacterTypeError(PasswordCheckStatus.NOT_ENOUGH_OF_CHARACTER_GROUP, missingCharacterListIndex, missingCharacterList, expectedCount, actualCount);
    }

    static PasswordCheckError tooManyOfCharacterType(int missingCharacterListIndex, String missingCharacterList, int expectedCount, int actualCount) {
        return new BadCountForCharacterTypeError(PasswordCheckStatus.TOO_MANY_OF_CHARACTER_GROUP, missingCharacterListIndex, missingCharacterList, expectedCount, actualCount);
    }

    public PasswordCheckStatus getErrorType() {
        return this.errorType;
    }
}

