/*
 * Decompiled with CFR 0.152.
 */
package rodeo.password.pgencheck;

import java.util.Collections;
import java.util.List;

abstract class PasswordData {
    private final List<String> charGroups;
    private final List<Integer> groupMinCounts;
    private final List<Integer> groupMaxCounts;
    private final String allChars;

    PasswordData(List<String> charGroups, List<Integer> groupMinCounts, List<Integer> groupMaxCounts) {
        this.charGroups = charGroups;
        this.groupMinCounts = groupMinCounts;
        this.groupMaxCounts = groupMaxCounts;
        StringBuilder chars = new StringBuilder();
        for (String charSet : charGroups) {
            chars.append(charSet);
        }
        this.allChars = chars.toString();
    }

    List<String> charGroups() {
        return this.charGroups;
    }

    List<Integer> groupMinCounts() {
        return this.groupMinCounts;
    }

    List<Integer> groupMaxCounts() {
        return this.groupMaxCounts;
    }

    public List<String> getCharacterGroups() {
        return Collections.unmodifiableList(this.charGroups);
    }

    public int getCharacterGroupCount() {
        return this.charGroups.size();
    }

    public String getCharacterGroup(int index) {
        if (!this.indexOK(index)) {
            throw new IndexOutOfBoundsException(this.getBadIndexErrorMessage(index));
        }
        return this.charGroups.get(index);
    }

    public int getMinCharactersInGroup(int index) {
        if (!this.indexOK(index)) {
            throw new IndexOutOfBoundsException(this.getBadIndexErrorMessage(index));
        }
        return this.groupMinCounts.get(index);
    }

    public int getMaxCharactersInGroup(int index) {
        if (!this.indexOK(index)) {
            throw new IndexOutOfBoundsException(this.getBadIndexErrorMessage(index));
        }
        return this.groupMaxCounts.get(index);
    }

    private boolean indexOK(int index) {
        return index >= 0 && index < this.charGroups.size();
    }

    private String getBadIndexErrorMessage(int index) {
        return "Index must be between 0 and " + (this.charGroups.size() - 1) + ". Value received: " + index;
    }

    public String getAllChars() {
        return this.allChars;
    }
}

