/*
 * Copyright 2018 Arsen Ibragimov (ars)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//package ars.precondition.unstable
//
//import ars.precondition.Messages.{NoNameParameter, mustContainAtLeastOneOf, mustContainOnlyOneOf}
//import ars.precondition.Predicates.{isAtLeastOneOf, isOnlyOneOf}
//import ars.precondition.require.RequireCore
//
//import scala.collection.Iterable
//
///**
//  *
//  *
//  * @author Arsen Ibragimov (ars)
//  * @since 0.0.1
//  */
//trait RequireAtLeast extends RequireCore {
//  /**
//    * Tests that one and only one of elems of `seq` is contained in `value`
//    *
//    * @param value the value
//    * @param name the name to include in the failure message
//    * @param seq the sequence of values
//    * @param allowDups is allow duplicates
//    *
//    * @tparam T the type of value
//    */
//  @inline def requireOnlyOneOf[T](value: Iterable[T], name: String = NoNameParameter)
//                                 (seq: Iterable[T], allowDups: Boolean = false): Unit = {
//    require(
//      isOnlyOneOf(value, seq, allowDups),
//      mustContainOnlyOneOf(name, seq, allowDups)
//    )
//  }
//
//  /**
//    * Tests that at least one of elems of `seq` is contained in `value`
//    *
//    * @param value the value
//    * @param name the name to include in the failure message
//    * @param seq the sequence of values
//    * @param allowDups is allow duplicates
//    *
//    * @tparam T the type of value
//    */
//  @inline def requireAtLeastOneOf[T](value: Iterable[T], name: String = NoNameParameter)
//                                    (seq: Iterable[T], allowDups: Boolean = false): Unit = {
//    require(
//      isAtLeastOneOf(value, seq, allowDups),
//      mustContainAtLeastOneOf(name, seq, allowDups)
//    )
//  }
//}

//  def isNotEmptyRange[@specialized T: Numeric](leftBound: BoundedNumber[T], rightBound: BoundedNumber[T]): Boolean = {
//    val n = implicitly[Numeric[T]]
//    if (leftBound.value == rightBound.value) {
//      if (leftBound.isInstanceOf[Exclusive[_]] || rightBound.isInstanceOf[Exclusive[_]]) false
//      else true
//
//    } else if (n.lt(leftBound.value, rightBound.value)) {
//      if (leftBound.isInstanceOf[Exclusive[_]] && rightBound.isInstanceOf[Exclusive[_]])
//      true
//    }
//    true
//  }
