/*
 * Copyright Бездна (c) 2018.
 */
package ru.abyss.settings.importer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author Minu <<a href="minu-moto@mail.ru">minu-moto@mail.ru</a>>
 * @since 08.06.2018 22:53:00
 */
public class ImportTable {

	private String scheme;
	private String table;
	private Map<String, TableColumn> columns = new HashMap<String, TableColumn>();
	private Set<ImportTable> dependencies = new HashSet<ImportTable>();
	private Set<String> pKey = new HashSet<String>();

	public ImportTable(String scheme, String table) {
		this.scheme = scheme;
		this.table = table;
	}

	public String getScheme() {
		return scheme;
	}

	public String getTable() {
		return table;
	}
	public void setTable(String name) {
		table = name;
	}

	public void addPrimaryKey(String field) {
		pKey.add(field);
		TableColumn pk = columns.get(field);
		if (pk != null)
			pk.setPKey(true);
	}

	public void setPrimaryKey(Set<String> fields) {
		pKey = new HashSet<String>(fields);
	}

	public Set<String> getPrimaryKey() {
		return pKey;
	}

	public void addColumn(String name, String type, boolean isNullable) {
		addColumn(new TableColumn(name, type, isNullable, pKey.contains(name)));
	}

	public void addColumn(TableColumn column) {
		columns.put(column.getName(), column);
	}

	public void removeColumn(String name) {
		columns.remove(name);
	}

	public TableColumn getColumn(String name) {
		return columns.get(name);
	}

	public Set<TableColumn> getColumns() {
		return Collections.unmodifiableSet(new HashSet<TableColumn>(columns.values()));
	}

	public boolean isIDPrimaryKey() {
		return (pKey.size() == 1) && "id".equalsIgnoreCase(pKey.iterator().next());
	}

	public void addDependency(ImportTable table) {
		dependencies.add(table);
	}

	public void removeDependency(ImportTable table) {
		dependencies.remove(table);
	}

	public Set<ImportTable> getDependencies() {
		return Collections.unmodifiableSet(dependencies);
	}

	@Override
	public String toString() {
		return scheme + "." + table;
	}

}