/*
 * Copyright Бездна (c) 2019.
 */
package ru.abyss.settings.importer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;

import ru.abyss.settings.ProgressCallback;

/**
 * @author Minu <<a href="minu-moto@mail.ru">minu-moto@mail.ru</a>>
 * @since 13.03.2019 17:05:41
 */
@ImporterVersion("1.4")
public class ImporterV14 extends ImporterV15 {

	@Override
	public void doImport(Connection h2Connection, Connection pgConnection, Long factoryId, Long userId,
			boolean isOwnFactory, boolean isLoadPrices, boolean isLoadConsistRemains, boolean isLoadContractors,
			ProgressCallback callback) throws Exception {
		// в версии 1.5 от таблицы settings.taccessory_connection_groups отпочковалась таблица settings.taccessory_connection_elements
		DatabaseMetaData metaData = h2Connection.getMetaData();
		try (ResultSet rs = metaData.getColumns(null, "SETTINGS", "TACCESSORY_CONNECTION_GROUPS", "SETTINGS_TELEMENT_ID")) {
			// проверяем есть ли столбец settings_telement_id
			if (rs.next())
				try (Statement st = h2Connection.createStatement()) {
					// создаём новую таблицу
					st.addBatch("create table settings.taccessory_connection_elements (id bigint not null, taccessory_connection_group_id bigint not null, settings_telement_id bigint not null, PRIMARY KEY(taccessory_connection_group_id, settings_telement_id), " + 
							"CONSTRAINT TACCESSORY_CONNECTION_ELEMENTS_GROUP_FK FOREIGN KEY (taccessory_connection_group_id) REFERENCES SETTINGS.TACCESSORY_CONNECTION_GROUPS(ID) ON DELETE CASCADE ON UPDATE CASCADE, " + 
							"CONSTRAINT TACCESSORY_CONNECTION_ELEMENTS_ELEMENT_FK FOREIGN KEY (settings_telement_id) REFERENCES SETTINGS.TELEMENTS(ID) ON DELETE CASCADE ON UPDATE CASCADE)");
					st.addBatch("COMMENT ON COLUMN settings.taccessory_connection_elements.id IS 'bigserial'");
					st.addBatch("COMMENT ON COLUMN settings.taccessory_connection_elements.taccessory_connection_group_id IS 'int8'");
					st.addBatch("COMMENT ON COLUMN settings.taccessory_connection_elements.settings_telement_id IS 'int8'");
					// заполняем новую таблицу данными
					st.addBatch(
							"insert into settings.taccessory_connection_elements (id, taccessory_connection_group_id, settings_telement_id) " +
							"select cg.id, cg.id, cg.settings_telement_id " +
							"from settings.taccessory_connection_groups cg " +
							"where cg.settings_telement_id is not null");
					// удаляем старые поля
					st.addBatch("ALTER TABLE settings.taccessory_connection_groups DROP COLUMN settings_telement_id");
					st.executeBatch();
					h2Connection.commit();
				} catch (Exception e) {
					h2Connection.rollback();
					throw e;
				}
		}

		super.doImport(h2Connection, pgConnection, factoryId, userId, isOwnFactory, isLoadPrices, isLoadConsistRemains, isLoadContractors, callback);
	}

}