/*
 * Copyright Бездна (c) 2018.
 */
package ru.abyss.settings.importer;

import java.sql.Connection;

/**
 * @author Minu <<a href="minu-moto@mail.ru">minu-moto@mail.ru</a>>
 * @since 29.06.2018 21:52:26
 */
@ImporterVersion("1.5")
public class ImporterV15 extends ImporterV16 {

	@Override
	protected ImportTable filterTable(Connection h2Connection, Connection pgConnection, ImportTable tbl) throws Exception {
		// в версии 1.6 из таблицы settings.taccessories удалилось поле side
		if ((tbl != null) && "SETTINGS.TACCESSORIES".equalsIgnoreCase(tbl.toString()))
			tbl.removeColumn("SIDE");
		return super.filterTable(h2Connection, pgConnection, tbl);
	}

}