/*
 * Copyright Бездна (c) 2018.
 */
package ru.abyss.settings.importer;

import java.sql.Connection;
import java.sql.PreparedStatement;

/**
 * @author Minu <<a href="minu-moto@mail.ru">minu-moto@mail.ru</a>>
 * @since 29.06.2018 21:52:26
 */
@ImporterVersion("1.8")
public class ImporterV18 extends ImporterV19 {

	@Override
	protected String getDestFieldMapper(ImportTable table, String field) {
		// в версии 1.9 в таблице stock.ttask_cnc поле cnt_code переименовалось в cnc_code
		if ("STOCK.TTASK_CNC".equalsIgnoreCase(table.toString()) && "cnt_code".equalsIgnoreCase(field))
			field = "cnc_code";
		return super.getDestFieldMapper(table, field);
	}

	@Override
	protected ImportTable filterTable(Connection h2Connection, Connection pgConnection, ImportTable tbl) throws Exception {
		// в версии 1.9 таблица stock.ttask_cnt переименовалась в stock.ttask_cnc
		if ((tbl != null) && "STOCK.TTASK_CNT".equalsIgnoreCase(tbl.toString())) {
			try (PreparedStatement alterStmt = h2Connection.prepareStatement("ALTER TABLE stock.ttask_cnt RENAME TO ttask_cnc")) {
				alterStmt.execute();
				h2Connection.commit();
			} catch (Exception e) {
				h2Connection.rollback();
				throw e;
			}
			tbl.setTable("TTASK_CNC");
		}
		return super.filterTable(h2Connection, pgConnection, tbl);
	}

}