/*
 * Copyright Бездна (c) 2018.
 */
package ru.abyss.settings.importer;

import java.sql.Connection;
import java.sql.PreparedStatement;

/**
 * @author Minu <<a href="minu-moto@mail.ru">minu-moto@mail.ru</a>>
 * @since 29.06.2018 21:52:26
 */
@ImporterVersion("1.10")
public class ImporterV110 extends ImporterCurrent {

	@Override
	protected ImportTable filterTable(Connection h2Connection, Connection pgConnection, ImportTable tbl) throws Exception {
		// где-то посреди версии 1.10 в таблице stock.tcolors добавились поля outside_tcolor_id и inside_tcolor_id
		// в каких-то архивах они есть, в каких-то нет, поэтому на всяких случай добавляем, без выкидывания исключений
		if ((tbl != null) && "STOCK.TCOLORS".equalsIgnoreCase(tbl.toString())) {
			try (PreparedStatement alterStmt = h2Connection.prepareStatement("ALTER TABLE stock.tcolors ADD COLUMN outside_tcolor_id BIGINT")) {
				alterStmt.execute();
				h2Connection.commit();
			} catch (Exception e) {
				h2Connection.rollback();
			}
			try (PreparedStatement alterStmt = h2Connection.prepareStatement("ALTER TABLE stock.tcolors ADD COLUMN inside_tcolor_id BIGINT")) {
				alterStmt.execute();
				h2Connection.commit();
			} catch (Exception e) {
				h2Connection.rollback();
			}
		}
		return super.filterTable(h2Connection, pgConnection, tbl);
	}

}