/*
 * Copyright Бездна (c) 2018.
 */
package ru.abyss.settings.importer;

import java.sql.Connection;

/**
 * @author Minu <<a href="minu-moto@mail.ru">minu-moto@mail.ru</a>>
 * @since 29.06.2018 21:52:26
 */
@ImporterVersion("1.11")
@ImporterVersion("1.12")
public class ImporterV112 extends ImporterV113 {

	@Override
	protected ImportTable filterTable(Connection h2Connection, Connection pgConnection, ImportTable tbl) throws Exception {
		// в версии 1.13 из таблицы settings.tfindings удалилось поле marker
		if ((tbl != null) && "SETTINGS.TFINDINGS".equalsIgnoreCase(tbl.toString()))
			tbl.removeColumn("MARKER");
		return super.filterTable(h2Connection, pgConnection, tbl);
	}

}