/*
 * Copyright Бездна (c) 2018.
 */
package ru.abyss.settings.importer;

import java.sql.Connection;

/**
 * @author Minu <<a href="minu-moto@mail.ru">minu-moto@mail.ru</a>>
 * @since 29.06.2018 21:52:26
 */
@ImporterVersion("1.13")
public class ImporterV113 extends ImporterV114 {

	@Override
	protected ImportTable filterTable(Connection h2Connection, Connection pgConnection, ImportTable tbl) throws Exception {
		// в версии 1.14 из таблицы catalog.taccount_numbers удалились поля календарного планирования
		if ((tbl != null) && "CATALOG.TACCOUNT_NUMBERS".equalsIgnoreCase(tbl.toString())) {
			tbl.removeColumn("MEASURE");
			tbl.removeColumn("PTO");
			tbl.removeColumn("SUPPLY1");
			tbl.removeColumn("SUPPLY2");
			tbl.removeColumn("SUPPLY3");
			tbl.removeColumn("SUPPLY4");
			tbl.removeColumn("PRODUCTION");
			tbl.removeColumn("REQUEST");
			tbl.removeColumn("ASSEMBLY");
			tbl.removeColumn("OUTPUT_STOCK");
			tbl.removeColumn("SHIPMENT");
		}
		// в версии 1.14 из таблицы settings.tprocessing_cnc удалились поля code и is_rolgang
		if ((tbl != null) && "SETTINGS.TPROCESSING_CNC".equalsIgnoreCase(tbl.toString())) {
			tbl.removeColumn("IS_ROLGANG");
			tbl.removeColumn("CODE");
		}
		return super.filterTable(h2Connection, pgConnection, tbl);
	}

}