/*
 * Copyright Бездна (c) 2024.
 */
package ru.abyss.settings.importer;

import java.sql.Connection;
import java.sql.Statement;

import ru.abyss.settings.ProgressCallback;

/**
 * @author Minu <<a href="minu-moto@mail.ru">minu-moto@mail.ru</a>>
 * @since 29.05.2024 16:03:26
 */
@ImporterVersion("1.14")
public class ImporterV114 extends ImporterV115 {

	@Override
	public void doImport(Connection h2Connection, Connection pgConnection, Long factoryId, Long userId,
			boolean isOwnFactory, boolean isLoadPrices, boolean isLoadConsistRemains, boolean isLoadContractors,
			boolean isLoad1C, ProgressCallback callback) throws Exception {
		// в версии 1.15 таблицы catalog.tstage_properties и catalog.tstage_schedules переехали в схему scheduling
		try (Statement alterStmt = h2Connection.createStatement()) {
			alterStmt.execute("CREATE SCHEMA scheduling");
			alterStmt.execute("CREATE TABLE SCHEDULING.TSTAGE_SCHEDULES (\r\n"
					+ "	ID BIGINT NOT NULL COMMENT 'bigserial',\r\n"
					+ "	NPP BIGINT COMMENT 'int8',\r\n"
					+ "	NAME VARCHAR COMMENT 'varchar',\r\n"
					+ "	PRIMARY KEY (ID)\r\n"
					+ ") AS TABLE catalog.tstage_schedules");
			alterStmt.execute("CREATE TABLE SCHEDULING.TSTAGE_PROPERTIES (\r\n"
					+ "	ID BIGINT NOT NULL COMMENT 'bigserial',\r\n"
					+ "	TACCOUNT_NUMBER_ID BIGINT NOT NULL COMMENT 'int8',\r\n"
					+ "	STAGE VARCHAR NOT NULL COMMENT 'scheduling.stage_type',\r\n"
					+ "	START_TYPE VARCHAR COMMENT 'scheduling.start_type',\r\n"
					+ "	MONDAY BOOLEAN COMMENT 'bool',\r\n"
					+ "	TUESDAY BOOLEAN COMMENT 'bool',\r\n"
					+ "	WEDNESDAY BOOLEAN COMMENT 'bool',\r\n"
					+ "	THURSDAY BOOLEAN COMMENT 'bool',\r\n"
					+ "	FRIDAY BOOLEAN COMMENT 'bool',\r\n"
					+ "	SATURDAY BOOLEAN COMMENT 'bool',\r\n"
					+ "	SUNDAY BOOLEAN COMMENT 'bool',\r\n"
					+ "	DAY_TYPE VARCHAR COMMENT 'scheduling.day_type',\r\n"
					+ "	DAY_COUNT BIGINT COMMENT 'int8',\r\n"
					+ "	PRODUCT_COUNT BIGINT COMMENT 'int8',\r\n"
					+ "	NEXT_STAGE VARCHAR COMMENT 'scheduling.stage_type',\r\n"
					+ "	TSTAGE_SCHEDULE_ID BIGINT COMMENT 'int8',\r\n"
					+ "	CONSTRAINT CONSTRAINT_CF PRIMARY KEY (TACCOUNT_NUMBER_ID,STAGE),\r\n"
					+ "	CONSTRAINT TSTAGE_PROPERTIES_ACC_NUMBER_FK FOREIGN KEY (TACCOUNT_NUMBER_ID) REFERENCES \"CATALOG\".TACCOUNT_NUMBERS(ID) ON DELETE CASCADE ON UPDATE CASCADE,\r\n"
					+ "	CONSTRAINT TSTAGE_PROPERTIES_FK FOREIGN KEY (TSTAGE_SCHEDULE_ID) REFERENCES \"SCHEDULING\".TSTAGE_SCHEDULES(ID) ON DELETE SET NULL ON UPDATE CASCADE\r\n"
					+ ") AS TABLE catalog.tstage_properties");
			alterStmt.execute("CREATE UNIQUE INDEX ON SCHEDULING.TSTAGE_PROPERTIES (ID)");
			alterStmt.execute("ALTER TABLE logistics.tdirection_timetables DROP CONSTRAINT tdirection_timetables_fk");
			alterStmt.execute("ALTER TABLE logistics.tdirection_timetables\r\n"
					+ "  ADD CONSTRAINT tdirection_timetables_fk FOREIGN KEY (tstage_schedule_id)\r\n"
					+ "    REFERENCES scheduling.tstage_schedules(id)\r\n"
					+ "    ON DELETE SET NULL\r\n"
					+ "    ON UPDATE CASCADE\r\n"
					+ "    NOT DEFERRABLE");
			alterStmt.execute("DROP TABLE \"CATALOG\".TSTAGE_PROPERTIES");
			alterStmt.execute("DROP TABLE \"CATALOG\".TSTAGE_SCHEDULES");
			h2Connection.commit();
		} catch (Exception e) {
			h2Connection.rollback();
			throw e;
		}

		super.doImport(h2Connection, pgConnection, factoryId, userId, isOwnFactory, isLoadPrices, isLoadConsistRemains,
				isLoadContractors, isLoad1C, callback);
	}

}