/*
 * Copyright Бездна (c) 2024.
 */
package ru.abyss.settings.importer;

import java.sql.Connection;
import java.sql.Statement;

import ru.abyss.settings.ProgressCallback;

/**
 * @author Minu <<a href="minu-moto@mail.ru">minu-moto@mail.ru</a>>
 * @since 16.07.2024 16:03:26
 */
@ImporterVersion("1.15")
public class ImporterV115 extends ImporterCurrent {

	@Override
	public void doImport(Connection h2Connection, Connection pgConnection, Long factoryId, Long userId,
			boolean isOwnFactory, boolean isLoadPrices, boolean isLoadConsistRemains, boolean isLoadContractors,
			boolean isLoad1C, ProgressCallback callback) throws Exception {
		// в версии 1.16 перечисления catalog.stage_type, catalog.start_type и catalog.day_type переехали в схему scheduling
		try (Statement alterStmt = h2Connection.createStatement()) {
			alterStmt.execute("COMMENT ON COLUMN logistics.tdirection_timetables.start_type IS 'scheduling.start_type'");
			alterStmt.execute("COMMENT ON COLUMN logistics.tdirection_timetables.day_type IS 'scheduling.day_type'");
			alterStmt.execute("COMMENT ON COLUMN scheduling.tstage_properties.stage IS 'scheduling.stage_type'");
			alterStmt.execute("COMMENT ON COLUMN scheduling.tstage_properties.start_type IS 'scheduling.start_type'");
			alterStmt.execute("COMMENT ON COLUMN scheduling.tstage_properties.day_type IS 'scheduling.day_type'");
			alterStmt.execute("COMMENT ON COLUMN scheduling.tstage_properties.next_stage IS 'scheduling.stage_type'");
			h2Connection.commit();
		} catch (Exception e) {
			h2Connection.rollback();
			throw e;
		}

		super.doImport(h2Connection, pgConnection, factoryId, userId, isOwnFactory, isLoadPrices, isLoadConsistRemains,
				isLoadContractors, isLoad1C, callback);
	}

}