/*
 * Copyright Бездна (c) 2018.
 */
package ru.abyss.settings.importer;

import java.sql.Connection;
import java.sql.PreparedStatement;

/**
 * @author Minu <<a href="minu-moto@mail.ru">minu-moto@mail.ru</a>>
 * @since 29.06.2018 21:52:26
 */
@ImporterVersion("1.9")
public class ImporterV19 extends ImporterV110 {

	@Override
	protected ImportTable filterTable(Connection h2Connection, Connection pgConnection, ImportTable tbl) throws Exception {
		// в версии 1.10 из таблицы catalog.tproduct_types удалилось поле weight
		if ((tbl != null) && "CATALOG.TPRODUCT_TYPES".equalsIgnoreCase(tbl.toString()))
			tbl.removeColumn("WEIGHT");
		// в версии 1.10 удалилась таблица stock.tprofile_colors
		if ((tbl != null) && "STOCK.TPROFILE_COLORS".equalsIgnoreCase(tbl.toString()))
			return null;
		// в версии 1.10 в таблице stock.tcolors добавились поля outside_tcolor_id и inside_tcolor_id
		if ((tbl != null) && "STOCK.TCOLORS".equalsIgnoreCase(tbl.toString())) {
			try (PreparedStatement alterStmt = h2Connection.prepareStatement("ALTER TABLE stock.tcolors ADD COLUMN outside_tcolor_id BIGINT")) {
				alterStmt.execute();
				h2Connection.commit();
			} catch (Exception e) {
				h2Connection.rollback();
				throw e;
			}
			try (PreparedStatement alterStmt = h2Connection.prepareStatement("ALTER TABLE stock.tcolors ADD COLUMN inside_tcolor_id BIGINT")) {
				alterStmt.execute();
				h2Connection.commit();
			} catch (Exception e) {
				h2Connection.rollback();
				throw e;
			}
		}
		return super.filterTable(h2Connection, pgConnection, tbl);
	}

}