/*
 * Copyright Бездна (c) 2018.
 */
package ru.abyss.settings.importer;

import java.sql.Connection;

/**
 * @author Minu <<a href="minu-moto@mail.ru">minu-moto@mail.ru</a>>
 * @since 29.06.2018 21:52:26
 */
@ImporterVersion("1.7")
public class ImporterV17 extends ImporterCurrent {

	@Override
	protected String getDestFieldMapper(ImportTable table, String field) {
		// в версии 1.8 в таблице stock.tproperties_leafs поле up переименовалось в is_outside_opening
		if ("SETTINGS.TPROPERTIES_LEAFS".equalsIgnoreCase(table.toString()) && "up".equalsIgnoreCase(field))
			field = "is_outside_opening";
		return super.getDestFieldMapper(table, field);
	}

	@Override
	protected ImportTable filterTable(Connection h2Connection, Connection pgConnection, ImportTable tbl) throws Exception {
		// в версии 1.8 из таблицы settings.taccessories удалилось поле incut_num
		if ((tbl != null) && "STOCK.TPROPERTIES_LEAFS".equalsIgnoreCase(tbl.toString()))
			tbl.removeColumn("INCUT_NUM");
		// в версии 1.8.1 из таблиц contractors.tcustomers и contractors.tsuppliers удалилось поле order_v
		if ((tbl != null) && ("CONTRACTORS.TCUSTOMERS".equalsIgnoreCase(tbl.toString()) || "CONTRACTORS.TSUPPLIERS".equalsIgnoreCase(tbl.toString())))
			tbl.removeColumn("ORDER_V");
		return super.filterTable(h2Connection, pgConnection, tbl);
	}

}