/*
 * Decompiled with CFR 0.152.
 */
package ru.chervoniy;

import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Supplier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import ru.chervoniy.EsiaSignerBuilder;
import ru.chervoniy.exception.EsiaSignerException;

public class EsiaSigner {
    private final Supplier<String> signingAlgorithmSupplier;
    private final Supplier<String> signatureProviderSupplier;
    private final Supplier<KeyStore> keyStoreSupplier;
    private final Supplier<String> signingCertificateAliasSupplier;
    private final Supplier<String> privateKeyPasswordSupplier;
    private final Supplier<Boolean> detachedFlagSupplier;

    EsiaSigner(Supplier<String> signingAlgorithmSupplier, Supplier<String> signatureProviderSupplier, Supplier<KeyStore> keyStoreSupplier, Supplier<String> signingCertificateAliasSupplier, Supplier<String> privateKeyPasswordSupplier, Supplier<Boolean> detachedFlagSupplier) {
        this.signingAlgorithmSupplier = signingAlgorithmSupplier;
        this.signatureProviderSupplier = signatureProviderSupplier;
        this.keyStoreSupplier = keyStoreSupplier;
        this.signingCertificateAliasSupplier = signingCertificateAliasSupplier;
        this.privateKeyPasswordSupplier = privateKeyPasswordSupplier;
        this.detachedFlagSupplier = detachedFlagSupplier;
    }

    public static EsiaSignerBuilder builder() {
        return EsiaSignerBuilder.builder();
    }

    public byte[] signPkcs7(byte[] payload) throws EsiaSignerException {
        CMSProcessableByteArray cmsData = new CMSProcessableByteArray(payload);
        try {
            CMSSignedDataGenerator signatureProvider = this.getSignatureProvider();
            boolean detached = this.detachedFlagSupplier.get();
            CMSSignedData signedData = signatureProvider.generate((CMSTypedData)cmsData, !detached);
            return signedData.getEncoded();
        }
        catch (IOException | CMSException e) {
            throw new EsiaSignerException("Unable to sign payload", e);
        }
    }

    private CMSSignedDataGenerator getSignatureProvider() throws EsiaSignerException {
        KeyStore keyStore = this.keyStoreSupplier.get();
        Deque<X509Certificate> certificateChain = this.getCertificateChain();
        String keystorePassword = this.privateKeyPasswordSupplier.get();
        char[] keystorePasswordChars = keystorePassword.toCharArray();
        X509Certificate certificateForSign = certificateChain.getFirst();
        CMSSignedDataGenerator signedDataGenerator = new CMSSignedDataGenerator();
        try {
            String certificateAliasSupplier = this.signingCertificateAliasSupplier.get();
            Key key = keyStore.getKey(certificateAliasSupplier, keystorePasswordChars);
            String signatureProvider = this.signatureProviderSupplier.get();
            ContentSigner contentSigner = new JcaContentSignerBuilder(this.signingAlgorithmSupplier.get()).setProvider(signatureProvider).build((PrivateKey)key);
            DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().setProvider(signatureProvider).build();
            SignerInfoGenerator signerInfoGenerator = new JcaSignerInfoGeneratorBuilder(digestCalculatorProvider).build(contentSigner, certificateForSign);
            signedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
            byte[] certificateData = certificateForSign.getEncoded();
            X509CertificateHolder certificate = new X509CertificateHolder(certificateData);
            signedDataGenerator.addCertificate(certificate);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateEncodingException | CMSException | OperatorCreationException e) {
            throw new EsiaSignerException("Unable to create signature generator", e);
        }
        return signedDataGenerator;
    }

    private Deque<X509Certificate> getCertificateChain() throws EsiaSignerException {
        try {
            Certificate[] certificateChain;
            ArrayDeque<X509Certificate> certificateDeque = new ArrayDeque<X509Certificate>();
            KeyStore keyStore = this.keyStoreSupplier.get();
            String signingCertificateAlias = this.signingCertificateAliasSupplier.get();
            for (Certificate certificate : certificateChain = keyStore.getCertificateChain(signingCertificateAlias)) {
                certificateDeque.add((X509Certificate)certificate);
            }
            return certificateDeque;
        }
        catch (KeyStoreException e) {
            throw new EsiaSignerException("Unable to load certificates from chain", e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

