/*
 * Decompiled with CFR 0.152.
 */
package ru.chervoniy;

import java.security.KeyStore;
import java.util.function.Supplier;
import ru.chervoniy.EsiaSigner;

public class EsiaSignerBuilder {
    private static final String DEFAULT_SIGNATURE_PROVIDER = "BC";
    private static final String DEFAULT_SIGNATURE_ALGORITHM = "GOST3411-2012-256WITHECGOST3410-2012-256";
    private Supplier<String> signingAlgorithmSupplier = () -> "GOST3411-2012-256WITHECGOST3410-2012-256";
    private Supplier<String> signatureProviderSupplier = () -> "BC";
    private Supplier<KeyStore> keyStoreSupplier;
    private Supplier<String> signingCertificateAliasSupplier;
    private Supplier<String> privateKeyPasswordSupplier;
    private Supplier<Boolean> detachedFlagSupplier = () -> true;

    static EsiaSignerBuilder builder() {
        return new EsiaSignerBuilder();
    }

    public EsiaSignerBuilder signingAlgorithmSupplier(Supplier<String> signingAlgorithmSupplier) {
        this.signingAlgorithmSupplier = signingAlgorithmSupplier;
        return this;
    }

    public EsiaSignerBuilder signatureProviderSupplier(Supplier<String> signatureProviderSupplier) {
        this.signatureProviderSupplier = signatureProviderSupplier;
        return this;
    }

    public EsiaSignerBuilder keyStoreSupplier(Supplier<KeyStore> keyStoreSupplier) {
        this.keyStoreSupplier = keyStoreSupplier;
        return this;
    }

    public EsiaSignerBuilder signingCertificateAliasSupplier(Supplier<String> signingCertificateAliasSupplier) {
        this.signingCertificateAliasSupplier = signingCertificateAliasSupplier;
        return this;
    }

    public EsiaSignerBuilder privateKeyPasswordSupplier(Supplier<String> privateKeyPasswordSupplier) {
        this.privateKeyPasswordSupplier = privateKeyPasswordSupplier;
        return this;
    }

    public EsiaSignerBuilder detachedFlagSupplier(Supplier<Boolean> detachedFlagSupplier) {
        this.detachedFlagSupplier = detachedFlagSupplier;
        return this;
    }

    public EsiaSigner build() {
        return new EsiaSigner(this.signingAlgorithmSupplier, this.signatureProviderSupplier, this.keyStoreSupplier, this.signingCertificateAliasSupplier, this.privateKeyPasswordSupplier, this.detachedFlagSupplier);
    }
}

