/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.term;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.filter.AbstractFilter;
import ru.curs.celesta.dbutils.filter.Filter;
import ru.curs.celesta.dbutils.filter.Range;
import ru.curs.celesta.dbutils.filter.SingleValue;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.dbutils.term.AlwaysFalse;
import ru.curs.celesta.dbutils.term.AlwaysTrue;
import ru.curs.celesta.dbutils.term.AndTerm;
import ru.curs.celesta.dbutils.term.CsqlWhereTermsMaker;
import ru.curs.celesta.dbutils.term.FieldCompTerm;
import ru.curs.celesta.dbutils.term.FieldsCortegeTerm;
import ru.curs.celesta.dbutils.term.InTerm;
import ru.curs.celesta.dbutils.term.IsNull;
import ru.curs.celesta.dbutils.term.NotTerm;
import ru.curs.celesta.dbutils.term.OrTerm;
import ru.curs.celesta.dbutils.term.RangeTerm;
import ru.curs.celesta.dbutils.term.SingleValueTerm;
import ru.curs.celesta.dbutils.term.ValuesCortegeTerm;
import ru.curs.celesta.dbutils.term.WhereMakerParamsProvider;
import ru.curs.celesta.dbutils.term.WhereTerm;
import ru.curs.celesta.dbutils.term.WhereTermCompareTerm;
import ru.curs.celesta.score.BasicTable;

public class WhereTermsMaker
extends CsqlWhereTermsMaker {
    static final int GT = 0;
    static final int GE = 1;
    static final int EQ = 2;
    static final int LE = 3;
    static final int LT = 4;
    private static final TermConstructor[] C = new TermConstructor[40];
    private final WhereMakerParamsProvider paramsProvider;
    private Object[] rec;

    public WhereTermsMaker(WhereMakerParamsProvider paramsProvider) {
        this.paramsProvider = paramsProvider;
    }

    static int ind(boolean nullable, boolean nf, boolean isNull, int op) {
        return ((nullable ? 4 : 0) + (nf ? 0 : 2) + (isNull ? 1 : 0)) * 5 + op;
    }

    public WhereTerm getHereWhereTerm(BasicTable t) {
        return AndTerm.construct((WhereTerm)WhereTermsMaker.getPKWhereTerm((BasicTable)t), (WhereTerm)this.getWhereTerm());
    }

    public WhereTerm getWhereTerm() {
        this.paramsProvider.initOrderBy();
        this.rec = this.paramsProvider.values();
        Object r = null;
        for (Map.Entry<String, AbstractFilter> e : this.paramsProvider.filters().entrySet()) {
            AbstractFilter f = e.getValue();
            WhereTerm l = f instanceof SingleValue ? new SingleValueTerm(e.getKey(), (SingleValue)f) : (f instanceof Range ? new RangeTerm(e.getKey(), (Range)f) : new FilterTerm(e.getKey(), (Filter)f));
            r = r == null ? l : AndTerm.construct((WhereTerm)l, (WhereTerm)r);
        }
        AlwaysTrue l = r == null ? AlwaysTrue.TRUE : r;
        r = this.paramsProvider.complexFilter() == null ? AlwaysTrue.TRUE : new ComplexFilterTerm();
        r = AndTerm.construct((WhereTerm)l, (WhereTerm)r);
        l = r == null ? AlwaysTrue.TRUE : r;
        r = this.paramsProvider.inFilter() == null ? AlwaysTrue.TRUE : new InTerm(this.paramsProvider.inFilter(), this.paramsProvider.dba());
        return AndTerm.construct((WhereTerm)l, (WhereTerm)r);
    }

    public WhereTerm getWhereTerm(char op) {
        boolean invert;
        this.paramsProvider.initOrderBy();
        switch (op) {
            case '>': {
                invert = false;
                break;
            }
            case '<': {
                invert = true;
                break;
            }
            case '=': {
                return AndTerm.construct((WhereTerm)this.getWhereTerm(), (WhereTerm)this.getEqualsWhereTerm(0));
            }
            default: {
                throw new CelestaException("Invalid navigation operator: %s", new Object[]{Character.valueOf(op)});
            }
        }
        if (this.paramsProvider.dba().supportsCortegeComparing()) {
            boolean allDescOrdersAreEquals;
            HashSet<Boolean> set = new HashSet<Boolean>();
            for (boolean bl : this.paramsProvider.descOrders()) {
                set.add(bl);
            }
            boolean bl = allDescOrdersAreEquals = set.size() == 1;
            if (allDescOrdersAreEquals) {
                boolean allOfSortFieldsAreNotNull = true;
                for (String sortField : this.paramsProvider.sortFields()) {
                    if (!this.paramsProvider.isNullable(sortField.substring(1, sortField.length() - 1))) continue;
                    allOfSortFieldsAreNotNull = false;
                    break;
                }
                if (allOfSortFieldsAreNotNull) {
                    FieldsCortegeTerm fieldsCortegeTerm = new FieldsCortegeTerm(Arrays.asList(this.paramsProvider.sortFields()));
                    ValuesCortegeTerm valuesCortegeTerm = new ValuesCortegeTerm(Arrays.stream(this.paramsProvider.sortFieldsIndices()).boxed().collect(Collectors.toList()));
                    String operator = invert ^ this.paramsProvider.descOrders()[0] ? "<" : ">";
                    return AndTerm.construct((WhereTerm)this.getWhereTerm(), (WhereTerm)new WhereTermCompareTerm(fieldsCortegeTerm, valuesCortegeTerm, operator));
                }
            }
        }
        int l = this.paramsProvider.sortFields().length;
        char[] ops = new char[l];
        for (int i = 0; i < l; ++i) {
            ops[i] = invert ^ this.paramsProvider.descOrders()[i] ? 60 : 62;
        }
        return AndTerm.construct((WhereTerm)this.getWhereTerm(), (WhereTerm)this.getWhereTerm(ops, 0));
    }

    private boolean isNull(int k) {
        return this.rec[this.paramsProvider.sortFieldsIndices()[k]] == null;
    }

    private WhereTerm getEqualsWhereTerm(int k) {
        String fieldName = this.paramsProvider.sortFields()[k];
        int fieldIndex = this.paramsProvider.sortFieldsIndices()[k];
        boolean nullable = this.treatAsNullable(fieldName);
        WhereTerm l = C[WhereTermsMaker.ind(nullable, this.paramsProvider.dba().nullsFirst(), this.isNull(k), 2)].create(fieldName, fieldIndex, this);
        if (this.paramsProvider.sortFields().length - 1 > k) {
            WhereTerm r = this.getEqualsWhereTerm(k + 1);
            return AndTerm.construct((WhereTerm)l, (WhereTerm)r);
        }
        return l;
    }

    private WhereTerm getWhereTerm(char[] ops, int k) {
        String fieldName = this.paramsProvider.sortFields()[k];
        int fieldIndex = this.paramsProvider.sortFieldsIndices()[k];
        boolean isNull = this.isNull(k);
        boolean nf = this.paramsProvider.dba().nullsFirst();
        boolean nullable = this.treatAsNullable(fieldName);
        if (this.paramsProvider.sortFields().length - 1 > k) {
            WhereTerm a = C[WhereTermsMaker.ind(nullable, nf, isNull, ops[k] == '>' ? 1 : 3)].create(fieldName, fieldIndex, this);
            WhereTerm b = C[WhereTermsMaker.ind(nullable, nf, isNull, ops[k] == '>' ? 0 : 4)].create(fieldName, fieldIndex, this);
            WhereTerm c = this.getWhereTerm(ops, k + 1);
            return AndTerm.construct((WhereTerm)a, (WhereTerm)OrTerm.construct((WhereTerm)b, (WhereTerm)c));
        }
        return C[WhereTermsMaker.ind(nullable, nf, isNull, ops[k] == '>' ? 0 : 4)].create(fieldName, fieldIndex, this);
    }

    private boolean treatAsNullable(String fieldName) {
        String name = WhereTermsMaker.unquot(fieldName);
        if (this.paramsProvider.isNullable(name)) {
            AbstractFilter f = this.paramsProvider.filters().get(name);
            return !(f instanceof SingleValue) && !(f instanceof Range);
        }
        return false;
    }

    public static String unquot(String name) {
        return name.substring(1, name.length() - 1);
    }

    static {
        WhereTermsMaker.C[0] = (f, i, m) -> new FieldCompTerm(f, i, ">");
        WhereTermsMaker.C[1] = (f, i, m) -> new FieldCompTerm(f, i, ">=");
        WhereTermsMaker.C[2] = (f, i, m) -> new FieldCompTerm(f, i, "=");
        WhereTermsMaker.C[3] = (f, i, m) -> new FieldCompTerm(f, i, "<=");
        WhereTermsMaker.C[4] = (f, i, m) -> new FieldCompTerm(f, i, "<");
        WhereTermsMaker.C[5] = (f, i, m) -> AlwaysTrue.TRUE;
        WhereTermsMaker.C[6] = C[5];
        WhereTermsMaker.C[7] = (f, i, m) -> AlwaysFalse.FALSE;
        WhereTermsMaker.C[8] = C[7];
        WhereTermsMaker.C[9] = C[7];
        WhereTermsMaker.C[10] = C[0];
        WhereTermsMaker.C[11] = C[1];
        WhereTermsMaker.C[12] = C[2];
        WhereTermsMaker.C[13] = C[3];
        WhereTermsMaker.C[14] = C[4];
        WhereTermsMaker.C[15] = C[7];
        WhereTermsMaker.C[16] = C[7];
        WhereTermsMaker.C[17] = C[7];
        WhereTermsMaker.C[18] = C[5];
        WhereTermsMaker.C[19] = C[5];
        WhereTermsMaker.C[20] = C[0];
        WhereTermsMaker.C[21] = C[1];
        WhereTermsMaker.C[22] = C[2];
        WhereTermsMaker.C[23] = (f, i, m) -> OrTerm.construct((WhereTerm)new FieldCompTerm(f, i, "<="), (WhereTerm)new IsNull(f));
        WhereTermsMaker.C[24] = (f, i, m) -> OrTerm.construct((WhereTerm)new FieldCompTerm(f, i, "<"), (WhereTerm)new IsNull(f));
        WhereTermsMaker.C[25] = (f, i, m) -> NotTerm.construct((WhereTerm)new IsNull(f));
        WhereTermsMaker.C[26] = C[5];
        WhereTermsMaker.C[27] = (f, i, m) -> new IsNull(f);
        WhereTermsMaker.C[28] = C[27];
        WhereTermsMaker.C[29] = C[7];
        WhereTermsMaker.C[30] = (f, i, m) -> OrTerm.construct((WhereTerm)new FieldCompTerm(f, i, ">"), (WhereTerm)new IsNull(f));
        WhereTermsMaker.C[31] = (f, i, m) -> OrTerm.construct((WhereTerm)new FieldCompTerm(f, i, ">="), (WhereTerm)new IsNull(f));
        WhereTermsMaker.C[32] = C[2];
        WhereTermsMaker.C[33] = C[3];
        WhereTermsMaker.C[34] = C[4];
        WhereTermsMaker.C[35] = C[7];
        WhereTermsMaker.C[36] = C[27];
        WhereTermsMaker.C[37] = C[27];
        WhereTermsMaker.C[38] = C[5];
        WhereTermsMaker.C[39] = C[25];
    }

    final class ComplexFilterTerm
    extends WhereTerm {
        ComplexFilterTerm() {
        }

        public String getWhere() {
            return "(" + WhereTermsMaker.this.paramsProvider.complexFilter().getSQL(WhereTermsMaker.this.paramsProvider.dba()) + ")";
        }

        public void programParams(List<ParameterSetter> program, QueryBuildingHelper queryBuildingHelper) {
        }
    }

    final class FilterTerm
    extends WhereTerm {
        private final String fieldName;
        private final Filter filter;

        FilterTerm(String fieldName, Filter filter) {
            this.fieldName = fieldName;
            this.filter = filter;
        }

        public String getWhere() {
            return "(" + this.filter.makeWhereClause("\"" + this.fieldName + "\"", WhereTermsMaker.this.paramsProvider.dba()) + ")";
        }

        public void programParams(List<ParameterSetter> program, QueryBuildingHelper queryBuildingHelper) {
        }
    }

    @FunctionalInterface
    private static interface TermConstructor {
        public WhereTerm create(String var1, int var2, WhereTermsMaker var3);
    }
}

