/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.util.Objects;
import java.util.function.Function;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.ViewCursor;
import ru.curs.celesta.dbutils.filter.In;
import ru.curs.celesta.dbutils.filter.value.FieldsLookup;
import ru.curs.celesta.dbutils.term.WhereTermsMaker;

public final class InFilterHolder {
    private final BasicCursor cursor;
    private In inFilter;

    public InFilterHolder(BasicCursor cursor) {
        this.cursor = cursor;
    }

    final FieldsLookup setIn(BasicCursor otherCursor) {
        FieldsLookup fieldsLookup;
        Runnable lookupChangeCallback = () -> {
            if (!this.cursor.isClosed()) {
                this.cursor.closeSet();
            }
        };
        Function<FieldsLookup, Void> newLookupCallback = lookup -> {
            this.inFilter.addLookup((FieldsLookup)lookup, lookup.getOtherCursor().getQmaker());
            return null;
        };
        if (this.cursor instanceof Cursor) {
            fieldsLookup = new FieldsLookup((Cursor)this.cursor, otherCursor, lookupChangeCallback, newLookupCallback);
        } else if (this.cursor instanceof ViewCursor) {
            fieldsLookup = new FieldsLookup((ViewCursor)this.cursor, otherCursor, lookupChangeCallback, newLookupCallback);
        } else {
            throw new CelestaException("Not supported cursor type: %s", new Object[]{((Object)((Object)this.cursor)).getClass().getSimpleName()});
        }
        WhereTermsMaker otherWhereTermMaker = otherCursor.getQmaker();
        this.inFilter = new In(fieldsLookup, otherWhereTermMaker);
        return fieldsLookup;
    }

    final In getIn() {
        return this.inFilter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InFilterHolder)) {
            return false;
        }
        InFilterHolder other = (InFilterHolder)o;
        return Objects.equals(this.inFilter, other.inFilter);
    }
}

