/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.PermissionDeniedException;
import ru.curs.celesta.dbutils.Action;
import ru.curs.celesta.dbutils.BLOB;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.CursorGetHelper;
import ru.curs.celesta.dbutils.ILoggingManager;
import ru.curs.celesta.dbutils.InFilterHolder;
import ru.curs.celesta.dbutils.InFilterSupport;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.filter.In;
import ru.curs.celesta.dbutils.filter.value.FieldsLookup;
import ru.curs.celesta.dbutils.stmt.MaskedStatementHolder;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.dbutils.stmt.PreparedStatementHolderFactory;
import ru.curs.celesta.dbutils.stmt.PreparedStmtHolder;
import ru.curs.celesta.dbutils.term.WhereTerm;
import ru.curs.celesta.dbutils.term.WhereTermsMaker;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.GrainElement;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.Table;
import ru.curs.celesta.score.TableElement;

public abstract class Cursor
extends BasicCursor
implements InFilterSupport {
    private Table meta = null;
    final CursorGetHelper getHelper;
    private InFilterHolder inFilterHolder;
    final MaskedStatementHolder insert = PreparedStatementHolderFactory.createInsertHolder((BasicTable)this.meta(), (DBAdaptor)this.db(), (Connection)this.conn());
    boolean[] updateMask = null;
    boolean[] nullUpdateMask = null;
    final PreparedStmtHolder update = PreparedStatementHolderFactory.createUpdateHolder((BasicTable)this.meta(), (DBAdaptor)this.db(), (Connection)this.conn(), () -> this.updateMask, () -> this.nullUpdateMask);
    final PreparedStmtHolder delete = new PreparedStmtHolder(){

        protected PreparedStatement initStatement(List<ParameterSetter> program) {
            WhereTerm where = WhereTermsMaker.getPKWhereTerm((BasicTable)Cursor.this.meta());
            where.programParams(program, (QueryBuildingHelper)Cursor.this.db());
            return Cursor.this.db().getDeleteRecordStatement(Cursor.this.conn(), (TableElement)Cursor.this.meta(), where.getWhere());
        }
    };
    private final PreparedStmtHolder deleteAll = new PreparedStmtHolder(){

        protected PreparedStatement initStatement(List<ParameterSetter> program) {
            WhereTerm where = Cursor.this.getQmaker().getWhereTerm();
            where.programParams(program, (QueryBuildingHelper)Cursor.this.db());
            return Cursor.this.db().deleteRecordSetStatement(Cursor.this.conn(), (TableElement)Cursor.this.meta(), where.getWhere());
        }
    };
    private byte canOptimizeInsertion;
    private Cursor xRec;
    private int recversion;

    public Cursor(CallContext context) {
        super(context);
        CursorGetHelper.CursorGetHelperBuilder cghb = new CursorGetHelper.CursorGetHelperBuilder();
        cghb.withDb(this.db()).withConn(this.conn()).withMeta((TableElement)this.meta()).withTableName(this._objectName());
        this.getHelper = cghb.build();
        this.inFilterHolder = new InFilterHolder(this);
    }

    public Cursor(CallContext context, ColumnMeta<?> ... columns) {
        this(context, Arrays.stream(columns).map(ColumnMeta::getName).collect(Collectors.toSet()));
    }

    public Cursor(CallContext context, Set<String> fields) {
        super(context, fields);
        CursorGetHelper.CursorGetHelperBuilder cghb = new CursorGetHelper.CursorGetHelperBuilder();
        cghb.withDb(this.db()).withConn(this.conn()).withMeta((TableElement)this.meta()).withTableName(this._objectName()).withFields(this.fieldsForStatement);
        this.getHelper = cghb.build();
        this.inFilterHolder = new InFilterHolder(this);
    }

    public static Cursor create(Table table, CallContext callContext) {
        return (Cursor)BasicCursor.create((DataGrainElement)table, callContext);
    }

    public static Cursor create(Table table, CallContext callContext, Set<String> fields) {
        return (Cursor)BasicCursor.create((DataGrainElement)table, callContext, fields);
    }

    @Override
    PreparedStmtHolder getHereHolder() {
        return new PreparedStmtHolder(){

            protected PreparedStatement initStatement(List<ParameterSetter> program) {
                WhereTerm where = Cursor.this.getQmaker().getHereWhereTerm((BasicTable)Cursor.this.meta());
                where.programParams(program, (QueryBuildingHelper)Cursor.this.db());
                return Cursor.this.db().getNavigationStatement(Cursor.this.conn(), Cursor.this.getFrom(), "", where.getWhere(), Cursor.this.fieldsForStatement, 0L);
            }
        };
    }

    @Override
    protected void closeInternal() {
        super.closeInternal();
        if (this.xRec != null) {
            this.xRec.close();
        }
        this.closeStatements(new PreparedStmtHolder[]{this.getHelper.getHolder(), this.insert, this.delete, this.update});
    }

    public final void insert() {
        if (!this.tryInsert()) {
            throw new CelestaException("Record %s %s already exists", new Object[]{this._objectName(), Arrays.toString(this._currentKeyValues())});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean tryInsert() {
        if (!this.canInsert()) {
            throw new PermissionDeniedException((CallContext)this.callContext(), (GrainElement)this.meta(), Action.INSERT);
        }
        this.preInsert();
        try {
            if (!this.canOptimizeInsertion()) {
                PreparedStatement g = this.getHelper.prepareGet(this.recversion, this._currentKeyValues());
                ResultSet rs = g.executeQuery();
                Object object = null;
                try {
                    if (rs.next()) {
                        this.getXRec()._parseResult(rs);
                        if (this.getRecversion() == 0) {
                            this.setRecversion(this.xRec.getRecversion());
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        if (object != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            PreparedStatement ins = this.insert.getStatement(this._currentValues(), this.recversion);
            ILoggingManager loggingManager = ((CallContext)this.callContext()).getLoggingManager();
            if (ins.execute()) {
                loggingManager.log(this, Action.INSERT);
                ResultSet ret = ins.getResultSet();
                ret.next();
                int id = ret.getInt(1);
                this._setAutoIncrement(id);
                ret.close();
            } else {
                loggingManager.log(this, Action.INSERT);
                for (Column c : this.meta().getColumns().values()) {
                    IntegerColumn ic;
                    if (!(c instanceof IntegerColumn) || (ic = (IntegerColumn)c).getSequence() == null) continue;
                    this._setAutoIncrement(this.db().getCurrentIdent(this.conn(), (BasicTable)this.meta()));
                    break;
                }
            }
            this.getHelper.internalGet(this::_parseResultInternal, Optional.of(this::initXRec), this.recversion, this._currentKeyValues());
            this.postInsert();
            return true;
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    final boolean canOptimizeInsertion() {
        if (this.canOptimizeInsertion == 0) {
            IntegerColumn intPkColumn;
            Column pkColumn;
            Collection pkColumns = this.meta().getPrimaryKey().values();
            this.canOptimizeInsertion = pkColumns.size() == 1 && (pkColumn = (Column)pkColumns.iterator().next()) instanceof IntegerColumn ? (byte)((intPkColumn = (IntegerColumn)pkColumn).getSequence() == null ? 1 : 2) : (byte)1;
        }
        return this.canOptimizeInsertion == 2 && this.getCurrentKeyValues()[0] == null;
    }

    public final void update() {
        if (!this.tryUpdate()) {
            throw new CelestaException("Record %s %s does not exist.", new Object[]{this._objectName(), Arrays.toString(this._currentKeyValues())});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean tryUpdate() {
        if (!this.canModify()) {
            throw new PermissionDeniedException((CallContext)this.callContext(), (GrainElement)this.meta(), Action.MODIFY);
        }
        this.preUpdate();
        PreparedStatement g = this.getHelper.prepareGet(this.recversion, this._currentKeyValues());
        try {
            try (ResultSet rs = g.executeQuery();){
                if (!rs.next()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.xRec == null) {
                    this.xRec = (Cursor)this._getBufferCopy((CallContext)this.callContext(), null);
                    this.xRec._parseResult(rs);
                }
            }
            Object[] values = this._currentValues();
            Object[] xValues = this.getXRec()._currentValues();
            boolean[] myMask = new boolean[values.length];
            boolean[] myNullsMask = new boolean[values.length];
            boolean notChanged = true;
            for (int i = 0; i < values.length; notChanged &= myMask[i], ++i) {
                myMask[i] = Cursor.compareValues(values[i], xValues[i]);
                myNullsMask[i] = values[i] == null;
            }
            if (notChanged) {
                return true;
            }
            if (!Arrays.equals(myMask, this.updateMask) || !Arrays.equals(myNullsMask, this.nullUpdateMask)) {
                this.update.close();
                this.updateMask = myMask;
                this.nullUpdateMask = myNullsMask;
            }
            if (this.getRecversion() == 0) {
                this.setRecversion(this.xRec.getRecversion());
            }
            PreparedStatement upd = this.update.getStatement(values, this.recversion);
            upd.execute();
            ILoggingManager loggingManager = ((CallContext)this.callContext()).getLoggingManager();
            loggingManager.log(this, Action.MODIFY);
            if (this.meta().isVersioned()) {
                ++this.recversion;
            }
            this.initXRec();
            this.postUpdate();
            return true;
        }
        catch (SQLException e) {
            if (e.getMessage().contains("record version check failure")) {
                throw new CelestaException("Can not update %s.%s(%s): this record has been already modified by someone. Please start updating again.", new Object[]{this.meta().getGrain().getName(), this.meta().getName(), Arrays.toString(this._currentKeyValues())});
            }
            throw new CelestaException("Update of %s.%s (%s) failure: %s", new Object[]{this.meta().getGrain().getName(), this.meta().getName(), Arrays.toString(this._currentKeyValues()), e.getMessage()});
        }
    }

    private static boolean compareValues(Object newVal, Object oldVal) {
        if (newVal == null) {
            return oldVal == null || oldVal instanceof BLOB;
        }
        if (newVal instanceof BLOB) {
            return !((BLOB)newVal).isModified();
        }
        return newVal.equals(oldVal);
    }

    public final void delete() {
        if (!this.canDelete()) {
            throw new PermissionDeniedException((CallContext)this.callContext(), (GrainElement)this.meta(), Action.DELETE);
        }
        PreparedStatement del = this.delete.getStatement(this._currentValues(), this.recversion);
        try {
            this.preDelete();
            del.execute();
            ILoggingManager loggingManager = ((CallContext)this.callContext()).getLoggingManager();
            loggingManager.log(this, Action.DELETE);
            this.initXRec();
            this.postDelete();
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    private void initXRec() {
        if (this.xRec == null) {
            this.xRec = (Cursor)this._getBufferCopy((CallContext)this.callContext(), null);
        } else {
            this.xRec.copyFieldsFrom(this);
        }
    }

    public final void deleteAll() {
        if (!this.canDelete()) {
            throw new PermissionDeniedException((CallContext)this.callContext(), (GrainElement)this.meta(), Action.DELETE);
        }
        PreparedStatement stmt = this.deleteAll.getStatement(this._currentValues(), this.recversion);
        try {
            try {
                stmt.executeUpdate();
            }
            finally {
                this.deleteAll.close();
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    public final void getByValuesArray(Object ... values) {
        if (!this.tryGetByValuesArray(values)) {
            StringBuilder sb = new StringBuilder();
            for (Object value : values) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(value == null ? "null" : value.toString());
            }
            throw new CelestaException("There is no %s (%s).", new Object[]{this._objectName(), sb.toString()});
        }
    }

    public boolean tryGetByValuesArray(Object ... values) {
        if (!this.canRead()) {
            throw new PermissionDeniedException((CallContext)this.callContext(), (GrainElement)this.meta(), Action.READ);
        }
        return this.getHelper.internalGet(this::_parseResultInternal, Optional.of(this::initXRec), this.recversion, values);
    }

    public final boolean tryGetCurrent() {
        if (!this.canRead()) {
            throw new PermissionDeniedException((CallContext)this.callContext(), (GrainElement)this.meta(), Action.READ);
        }
        return this.getHelper.internalGet(this::_parseResultInternal, Optional.of(this::initXRec), this.recversion, this._currentKeyValues());
    }

    public final void setRecversion(int v) {
        this.recversion = v;
    }

    public final int getRecversion() {
        return this.recversion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BLOB calcBlob(String name) {
        BLOB result;
        ColumnMeta<?> c = this.validateColumnName(name);
        if (!(c instanceof BinaryColumn)) {
            throw new CelestaException("'%s' is not a BLOB column.", new Object[]{c.getName()});
        }
        BinaryColumn bc = (BinaryColumn)c;
        ArrayList program = new ArrayList();
        WhereTerm w = WhereTermsMaker.getPKWhereTerm((BasicTable)this.meta);
        PreparedStatement stmt = this.db().getOneFieldStatement(this.conn(), (Column)bc, w.getWhere());
        int i = 1;
        w.programParams(program, (QueryBuildingHelper)this.db());
        Object[] rec = this._currentValues();
        for (ParameterSetter f : program) {
            f.execute(stmt, i++, rec, this.recversion);
        }
        try {
            block21: {
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        InputStream is = rs.getBinaryStream(1);
                        if (is != null && !rs.wasNull()) {
                            try {
                                result = new BLOB(is);
                                break block21;
                            }
                            finally {
                                is.close();
                            }
                        }
                        result = new BLOB();
                        break block21;
                    }
                    result = new BLOB();
                }
            }
            stmt.close();
        }
        catch (IOException | SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return result;
    }

    @Deprecated
    public final int getMaxStrLen(String name) {
        ColumnMeta<?> c = this.validateColumnName(name);
        if (c instanceof StringColumn) {
            StringColumn sc = (StringColumn)c;
            return this.getMaxStrLen((ColumnMeta<String>)sc);
        }
        throw new CelestaException("Column %s is not of string type.", new Object[]{c.getName()});
    }

    public final int getMaxStrLen(ColumnMeta<String> column) {
        int undefinedMaxlength = -1;
        if (column instanceof StringColumn) {
            StringColumn sc = (StringColumn)column;
            return sc.isMax() ? -1 : sc.getLength();
        }
        return -1;
    }

    public final void init() {
        this._clearBuffer(false);
        this.setRecversion(0);
        if (this.xRec != null) {
            this.xRec.close();
        }
        this.xRec = null;
    }

    public final Table meta() {
        if (this.meta == null) {
            try {
                this.meta = (Table)((CallContext)this.callContext()).getScore().getGrain(this._grainName()).getElement(this._objectName(), Table.class);
            }
            catch (ParseException e) {
                throw new CelestaException(e.getMessage());
            }
        }
        return this.meta;
    }

    @Override
    final void appendPK(List<String> l, List<Boolean> ol, Set<String> colNames) {
        for (String colName : this.meta().getPrimaryKey().keySet()) {
            if (colNames.contains(colName)) continue;
            l.add(String.format("\"%s\"", colName));
            ol.add(Boolean.FALSE);
        }
    }

    @Override
    public final void clear() {
        super.clear();
        this.setRecversion(0);
        if (this.xRec != null) {
            this.xRec.close();
        }
        this.xRec = null;
    }

    public final Cursor getXRec() {
        if (this.xRec == null) {
            try {
                this.initXRec();
                this.xRec.clear();
            }
            catch (CelestaException e) {
                this.xRec = null;
            }
        }
        return this.xRec;
    }

    @Override
    public FieldsLookup setIn(BasicCursor otherCursor) {
        return this.inFilterHolder.setIn(otherCursor);
    }

    @Override
    public In getIn() {
        return this.inFilterHolder.getIn();
    }

    @Override
    protected void resetSpecificState() {
        this.inFilterHolder = new InFilterHolder(this);
    }

    @Override
    protected void clearSpecificState() {
        this.inFilterHolder = new InFilterHolder(this);
    }

    @Override
    protected void copySpecificFiltersFrom(BasicCursor bc) {
        Cursor c = (Cursor)bc;
        this.inFilterHolder = c.inFilterHolder;
    }

    @Override
    boolean isEquivalentSpecific(BasicCursor bc) {
        Cursor c = (Cursor)bc;
        return Objects.equals(this.inFilterHolder, c.inFilterHolder);
    }

    public final Object[] getCurrentKeyValues() {
        return this._currentKeyValues();
    }

    @Override
    protected void _parseResult(ResultSet rs) throws SQLException {
        this._parseResultInternal(rs);
        this.initXRec();
    }

    private void preDelete() {
        ((CallContext)this.callContext()).getCelesta().getTriggerDispatcher().fireTrigger(TriggerType.PRE_DELETE, this);
    }

    private void postDelete() {
        ((CallContext)this.callContext()).getCelesta().getTriggerDispatcher().fireTrigger(TriggerType.POST_DELETE, this);
    }

    private void preUpdate() {
        ((CallContext)this.callContext()).getCelesta().getTriggerDispatcher().fireTrigger(TriggerType.PRE_UPDATE, this);
    }

    private void postUpdate() {
        ((CallContext)this.callContext()).getCelesta().getTriggerDispatcher().fireTrigger(TriggerType.POST_UPDATE, this);
    }

    private void preInsert() {
        ((CallContext)this.callContext()).getCelesta().getTriggerDispatcher().fireTrigger(TriggerType.PRE_INSERT, this);
    }

    private void postInsert() {
        ((CallContext)this.callContext()).getCelesta().getTriggerDispatcher().fireTrigger(TriggerType.POST_INSERT, this);
    }

    protected abstract Object[] _currentKeyValues();

    protected abstract void _setAutoIncrement(int var1);

    protected abstract void _parseResultInternal(ResultSet var1) throws SQLException;
}

