/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.query.FromClause;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.ParseException;

public abstract class ParameterizedViewCursor
extends BasicCursor {
    private ParameterizedView meta = null;
    protected Map<String, Object> parameters = null;

    public ParameterizedViewCursor(CallContext context, Map<String, Object> parameters) {
        super(context);
        this.initParameters(parameters);
    }

    public ParameterizedViewCursor(CallContext context, Map<String, Object> parameters, ColumnMeta<?> ... columns) {
        this(context, Arrays.stream(columns).map(ColumnMeta::getName).collect(Collectors.toSet()), parameters);
    }

    public ParameterizedViewCursor(CallContext context, Set<String> fields, Map<String, Object> parameters) {
        super(context, fields);
        this.initParameters(parameters);
    }

    public static ParameterizedViewCursor create(ParameterizedView view, CallContext callContext, Map<String, Object> parameters) {
        try {
            return (ParameterizedViewCursor)ParameterizedViewCursor.getCursorClass((DataGrainElement)view).getConstructor(CallContext.class, Map.class).newInstance(callContext, parameters);
        }
        catch (ReflectiveOperationException ex) {
            throw new CelestaException("Cursor creation failed for grain element: " + view.getName(), (Throwable)ex);
        }
    }

    public static ParameterizedViewCursor create(ParameterizedView view, CallContext callContext, Set<String> fields, Map<String, Object> parameters) {
        try {
            return (ParameterizedViewCursor)ParameterizedViewCursor.getCursorClass((DataGrainElement)view).getConstructor(CallContext.class, Set.class, Map.class).newInstance(callContext, fields, parameters);
        }
        catch (ReflectiveOperationException ex) {
            throw new CelestaException("Cursor creation failed for grain element: " + view.getName(), (Throwable)ex);
        }
    }

    private void initParameters(Map<String, Object> parameters) {
        if (!this.meta().getParameters().keySet().containsAll(parameters.keySet())) {
            throw new CelestaException("Not all required parameters were passed");
        }
        this.parameters = parameters;
    }

    public ParameterizedView meta() {
        if (this.meta == null) {
            try {
                this.meta = (ParameterizedView)((CallContext)this.callContext()).getScore().getGrain(this._grainName()).getElement(this._objectName(), ParameterizedView.class);
            }
            catch (ParseException e) {
                throw new CelestaException(e.getMessage());
            }
        }
        return this.meta;
    }

    @Override
    final void appendPK(List<String> l, List<Boolean> ol, Set<String> colNames) {
        if (colNames.isEmpty()) {
            l.add(String.format("\"%s\"", this.meta().getColumns().keySet().iterator().next()));
            ol.add(Boolean.FALSE);
        }
    }

    @Override
    protected FromClause getFrom() {
        FromClause result = new FromClause();
        ParameterizedView ge = this.meta();
        result.setGe((DataGrainElement)ge);
        result.setExpression(this.db().getCallFunctionSql(this.meta));
        List paramValues = this.meta().getParameters().keySet().stream().map(pName -> this.parameters.get(pName)).collect(Collectors.toList());
        result.setParameters(paramValues);
        return result;
    }
}

