/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.term;

import java.util.List;
import java.util.stream.Collectors;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.filter.In;
import ru.curs.celesta.dbutils.filter.value.FieldsLookup;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.dbutils.term.WhereTerm;
import ru.curs.celesta.dbutils.term.WhereTermsMaker;

public final class InTerm
extends WhereTerm {
    private final In filter;
    private final QueryBuildingHelper queryBuildingHelper;

    public InTerm(In filter, QueryBuildingHelper queryBuildingHelper) {
        this.filter = filter;
        this.queryBuildingHelper = queryBuildingHelper;
    }

    public String getWhere() {
        return this.filter.getLookupWhereTermMap().entrySet().stream().map(e -> this.buildWhereLookup((FieldsLookup)e.getKey(), (WhereTermsMaker)((Object)((Object)e.getValue())))).collect(Collectors.joining(" AND "));
    }

    public void programParams(List<ParameterSetter> program, QueryBuildingHelper queryBuildingHelper) {
        for (WhereTermsMaker wtm : this.filter.getOtherWhereTermMakers()) {
            if (wtm == null) continue;
            wtm.getWhereTerm().programParams(program, queryBuildingHelper);
        }
    }

    private String buildWhereLookup(FieldsLookup lookup, WhereTermsMaker whereTermsMaker) {
        String otherWhere = whereTermsMaker != null ? whereTermsMaker.getWhereTerm().getWhere() : "";
        return this.queryBuildingHelper.getInFilterClause(lookup.getFiltered(), lookup.getFiltering(), lookup.getFields(), lookup.getOtherFields(), otherWhere);
    }
}

