/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.filter.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.ViewCursor;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.Table;
import ru.curs.celesta.score.View;

public final class FieldsLookup {
    private final Class<? extends DataGrainElement> targetClass;
    private final DataGrainElement filtered;
    private final DataGrainElement filtering;
    private final List<String> fields = new ArrayList<String>();
    private final List<String> otherFields = new ArrayList<String>();
    private BasicCursor cursor;
    private BasicCursor otherCursor;
    private final Runnable lookupChangeCallback;
    private final Function<FieldsLookup, Void> newLookupCallback;

    public FieldsLookup(Cursor cursor, BasicCursor otherCursor, Runnable lookupChangeCallback, Function<FieldsLookup, Void> newLookupCallback) {
        this(BasicTable.class, cursor, (DataGrainElement)cursor.meta(), otherCursor, otherCursor.meta(), lookupChangeCallback, newLookupCallback);
    }

    public FieldsLookup(ViewCursor cursor, BasicCursor otherCursor, Runnable lookupChangeCallback, Function<FieldsLookup, Void> newLookupCallback) {
        this(View.class, cursor, (DataGrainElement)cursor.meta(), otherCursor, otherCursor.meta(), lookupChangeCallback, newLookupCallback);
    }

    private FieldsLookup(Class<? extends DataGrainElement> targetClass, BasicCursor cursor, DataGrainElement filtered, BasicCursor otherCursor, DataGrainElement filtering, Runnable lookupChangeCallback, Function<FieldsLookup, Void> newLookupCallback) {
        this.validateCursors(cursor, otherCursor);
        this.cursor = cursor;
        this.otherCursor = otherCursor;
        this.filtered = filtered;
        this.filtering = filtering;
        this.targetClass = targetClass;
        this.lookupChangeCallback = lookupChangeCallback;
        this.newLookupCallback = newLookupCallback;
        lookupChangeCallback.run();
    }

    public FieldsLookup(BasicTable table, BasicTable otherTable, Runnable lookupChangeCallback, Function<FieldsLookup, Void> newLookupCallback) {
        this.targetClass = BasicTable.class;
        this.filtered = table;
        this.filtering = otherTable;
        this.lookupChangeCallback = lookupChangeCallback;
        this.newLookupCallback = newLookupCallback;
        lookupChangeCallback.run();
    }

    public FieldsLookup(View view, View otherView, Runnable lookupChangeCallback, Function<FieldsLookup, Void> newLookupCallback) {
        this.targetClass = View.class;
        this.filtered = view;
        this.filtering = otherView;
        this.lookupChangeCallback = lookupChangeCallback;
        this.newLookupCallback = newLookupCallback;
        lookupChangeCallback.run();
    }

    private void validateCursors(BasicCursor cursor, BasicCursor otherCursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("Argument 'cursor' can't be null");
        }
        if (otherCursor == null) {
            throw new IllegalArgumentException("Argument 'otherCursor' can't be null");
        }
        if (cursor.callContext() != otherCursor.callContext()) {
            throw new CelestaException("CallContexts are not matching");
        }
    }

    public FieldsLookup and(BasicCursor otherCursor) {
        if (BasicTable.class.equals(this.targetClass)) {
            FieldsLookup fieldsLookup = new FieldsLookup((Cursor)this.cursor, otherCursor, this.lookupChangeCallback, this.newLookupCallback);
            this.newLookupCallback.apply(fieldsLookup);
            return fieldsLookup;
        }
        if (View.class.equals(this.targetClass)) {
            FieldsLookup fieldsLookup = new FieldsLookup((ViewCursor)this.cursor, otherCursor, this.lookupChangeCallback, this.newLookupCallback);
            this.newLookupCallback.apply(fieldsLookup);
            return fieldsLookup;
        }
        throw new CelestaException("Can't apply %s to %s for FieldsLookup", new Object[]{otherCursor.meta().getClass().getSimpleName(), this.filtered.getClass().getSimpleName()});
    }

    public FieldsLookup and(BasicTable filtering) {
        if (this.filtered instanceof BasicTable) {
            BasicTable filteredTable = (BasicTable)this.filtered;
            FieldsLookup fieldsLookup = new FieldsLookup(filteredTable, filtering, this.lookupChangeCallback, this.newLookupCallback);
            this.newLookupCallback.apply(fieldsLookup);
            return fieldsLookup;
        }
        throw new CelestaException("Can't apply Table to %s for FieldsLookup", new Object[]{this.filtered.getClass().getSimpleName()});
    }

    public FieldsLookup and(View filtering) {
        if (this.filtered instanceof View) {
            View filteredView = (View)this.filtered;
            FieldsLookup fieldsLookup = new FieldsLookup(filteredView, filtering, this.lookupChangeCallback, this.newLookupCallback);
            this.newLookupCallback.apply(fieldsLookup);
            return fieldsLookup;
        }
        throw new CelestaException("Can't apply Table to %s for FieldsLookup", new Object[]{this.filtered.getClass().getSimpleName()});
    }

    @Deprecated
    public FieldsLookup add(String field, String otherField) {
        try {
            return this.internalAdd(this.validateFilteredColumn(field), this.validateFilteringColumn(otherField));
        }
        catch (ParseException e) {
            throw new CelestaException(e.getMessage(), (Throwable)e);
        }
    }

    public <T> FieldsLookup add(ColumnMeta<T> column, ColumnMeta<T> otherColumn) {
        try {
            return this.internalAdd(column, otherColumn);
        }
        catch (ParseException e) {
            throw new CelestaException(e.getMessage(), (Throwable)e);
        }
    }

    private FieldsLookup internalAdd(ColumnMeta<?> column, ColumnMeta<?> otherColumn) throws ParseException {
        String columnName = column.getName();
        String otherColumnName = otherColumn.getName();
        this.validateFilteredColumn(columnName);
        this.validateFilteringColumn(otherColumnName);
        if (!column.getCelestaType().equals(otherColumn.getCelestaType())) {
            throw new CelestaException("Column type of %s.%s.%s is not equal to column type of %s.%s.%s", new Object[]{this.filtered.getGrain().getName(), this.filtered.getName(), columnName, this.filtering.getGrain().getName(), this.filtering.getName(), otherColumnName});
        }
        if (this.filtered instanceof Table && this.filtering instanceof Table) {
            ArrayList<String> fieldsToValidate = new ArrayList<String>(this.fields);
            fieldsToValidate.add(columnName);
            Set<List<Integer>> columnOrdersInIndicesSet = this.getColumnOrdersInIndicesSet(fieldsToValidate, (BasicTable)this.filtered);
            ArrayList<String> otherFieldsToValidate = new ArrayList<String>(this.otherFields);
            otherFieldsToValidate.add(otherColumnName);
            Set<List<Integer>> otherColumnOrdersInIndicesSet = this.getColumnOrdersInIndicesSet(otherFieldsToValidate, (BasicTable)this.filtering);
            columnOrdersInIndicesSet.retainAll(otherColumnOrdersInIndicesSet);
            if (columnOrdersInIndicesSet.isEmpty()) {
                throw new CelestaException("There is no indices with the same order of column(s) (\"%s\") from table table %s.%s and (\"%s\") from table table %s.%s", new Object[]{String.join((CharSequence)",", new HashSet<String>(fieldsToValidate)), this.filtered.getGrain().getName(), this.filtered.getName(), String.join((CharSequence)",", new HashSet<String>(otherFieldsToValidate)), this.filtering.getGrain().getName(), this.filtering.getName()});
            }
        }
        this.fields.add(columnName);
        this.otherFields.add(otherColumnName);
        this.validate();
        this.lookupChangeCallback.run();
        return this;
    }

    private ColumnMeta<?> validateFilteredColumn(String columnField) throws ParseException {
        ColumnMeta column = (ColumnMeta)this.filtered.getColumns().get(columnField);
        if (column == null) {
            throw new ParseException(String.format("Column '%s' not found in %s '%s.%s'", columnField, this.targetClass.getSimpleName(), this.filtered.getGrain().getName(), this.filtered.getName()));
        }
        return column;
    }

    private ColumnMeta<?> validateFilteringColumn(String columnField) throws ParseException {
        ColumnMeta column = (ColumnMeta)this.filtering.getColumns().get(columnField);
        if (column == null) {
            throw new ParseException(String.format("Column '%s' not found in %s '%s.%s'", columnField, this.targetClass.getSimpleName(), this.filtering.getGrain().getName(), this.filtering.getName()));
        }
        return column;
    }

    public void validate() {
        if (this.filtered instanceof Table && this.filtering instanceof Table) {
            Set<List<Integer>> columnOrdersInIndicesSet = this.getColumnOrdersInIndicesSet(this.fields, (BasicTable)this.filtered);
            Set<List<Integer>> otherColumnOrdersInIndicesSet = this.getColumnOrdersInIndicesSet(this.otherFields, (BasicTable)this.filtering);
            columnOrdersInIndicesSet.retainAll(otherColumnOrdersInIndicesSet);
            columnOrdersInIndicesSet.stream().forEach(Collections::sort);
            Optional<List> match = columnOrdersInIndicesSet.stream().filter(l -> l.equals(IntStream.range(0, l.size()).boxed().collect(Collectors.toList()))).findAny();
            match.orElseThrow(() -> new CelestaException("'In' filter validation failed. Fields matched for the filter for tables %s.%s and %s.%s are not covered by pks or indices on these tables.", new Object[]{this.filtered.getGrain().getName(), this.filtered.getName(), this.filtering.getGrain().getName(), this.filtering.getName()}));
        }
    }

    private Set<List<Integer>> getColumnOrdersInIndicesSet(List<String> fieldsToValidate, BasicTable table) {
        boolean pkContainsFields = table.getPrimaryKey().keySet().containsAll(fieldsToValidate);
        Set indexes = table.getIndices();
        List indexesToValidate = indexes.stream().filter(i -> i.getColumns().keySet().containsAll(fieldsToValidate)).collect(Collectors.toList());
        if (!pkContainsFields && indexesToValidate.isEmpty()) {
            throw new CelestaException("There is no pk or index which contains column(s) (\"%s\") in table %s.%s", new Object[]{String.join((CharSequence)",", new HashSet<String>(fieldsToValidate)), table.getGrain().getName(), table.getName()});
        }
        HashSet<List<Integer>> result = new HashSet<List<Integer>>();
        if (pkContainsFields) {
            ArrayList pkColNames = new ArrayList(table.getPrimaryKey().keySet());
            result.add(fieldsToValidate.stream().map(pkColNames::indexOf).collect(Collectors.toList()));
        }
        result.addAll(indexesToValidate.stream().map(i -> fieldsToValidate.stream().map(arg_0 -> ((Index)i).getColumnIndex(arg_0)).collect(Collectors.toList())).collect(Collectors.toSet()));
        return result;
    }

    public DataGrainElement getFiltered() {
        return this.filtered;
    }

    public DataGrainElement getFiltering() {
        return this.filtering;
    }

    public List<String> getFields() {
        return new ArrayList<String>(this.fields);
    }

    public List<String> getOtherFields() {
        return new ArrayList<String>(this.otherFields);
    }

    public BasicCursor getOtherCursor() {
        return this.otherCursor;
    }
}

