/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ICallContext;
import ru.curs.celesta.dbutils.Action;
import ru.curs.celesta.dbutils.CsqlBasicDataAccessor;
import ru.curs.celesta.dbutils.IPermissionManager;

public abstract class BasicDataAccessor
extends CsqlBasicDataAccessor<CallContext> {
    private BasicDataAccessor previousDataAccessor;
    private BasicDataAccessor nextDataAccessor;

    public BasicDataAccessor(CallContext context) {
        super((ICallContext)context);
        context.incDataAccessorsCount();
        this.previousDataAccessor = context.getLastDataAccessor();
        if (this.previousDataAccessor != null) {
            if (this.previousDataAccessor.nextDataAccessor != null) {
                throw new IllegalStateException();
            }
            this.previousDataAccessor.nextDataAccessor = this;
        }
        context.setLastDataAccessor(this);
    }

    protected void validateInitContext(CallContext context) {
        super.validateInitContext((ICallContext)context);
        if (context.getUserId() == null) {
            throw new CelestaException("Invalid context passed to %s constructor: user id is null.", new Object[]{((Object)((Object)this)).getClass().getName()});
        }
    }

    protected void closeInternal() {
        if (this == ((CallContext)this.callContext()).getLastDataAccessor()) {
            ((CallContext)this.callContext()).setLastDataAccessor(this.previousDataAccessor);
        }
        if (this.previousDataAccessor != null) {
            this.previousDataAccessor.nextDataAccessor = this.nextDataAccessor;
        }
        if (this.nextDataAccessor != null) {
            this.nextDataAccessor.previousDataAccessor = this.previousDataAccessor;
        }
        this.previousDataAccessor = null;
        this.nextDataAccessor = null;
        ((CallContext)this.callContext()).decDataAccessorsCount();
    }

    protected void clearSpecificState() {
    }

    public final boolean canRead() {
        if (this.isClosed()) {
            throw new CelestaException("DataAccessor is closed.");
        }
        IPermissionManager permissionManager = ((CallContext)this.callContext()).getPermissionManager();
        return permissionManager.isActionAllowed((CallContext)this.callContext(), this.meta(), Action.READ);
    }

    protected abstract String _grainName();

    protected abstract String _objectName();
}

