/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.plugin;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.BasicDataAccessor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.dbutils.MaterializedViewCursor;
import ru.curs.celesta.dbutils.ParameterizedViewCursor;
import ru.curs.celesta.dbutils.ReadOnlyTableCursor;
import ru.curs.celesta.dbutils.Sequence;
import ru.curs.celesta.dbutils.ViewCursor;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.GrainElement;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.Table;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.VersionedElement;
import ru.curs.celesta.score.View;

public final class CursorGenerator {
    private static final HashMap<Class<? extends GrainElement>, Function<GrainElement, Class<? extends BasicDataAccessor>>> GRAIN_ELEMENTS_TO_DATA_ACCESSORS = new HashMap();
    private static final Map<String, String> TRIGGER_REGISTRATION_METHOD_TO_TRIGGER_TYPE;

    private CursorGenerator() {
        throw new AssertionError();
    }

    protected static void generateCursor(GrainElement ge, File srcDir, String scorePath) {
        String sourcePackage = CursorGenerator.calcSourcePackage(ge, scorePath);
        if (sourcePackage.isEmpty()) {
            throw new CelestaException("Couldn't generate class file for %s.%s without package", new Object[]{ge.getGrain().getName(), ge.getName()});
        }
        String sourceFileNamePrefix = StringUtils.capitalize((String)ge.getName());
        boolean isVersionedGe = ge instanceof VersionedElement && ((VersionedElement)ge).isVersioned();
        String className = CursorGenerator.calcClassName(ge, sourceFileNamePrefix);
        TypeSpec.Builder cursorClass = CursorGenerator.buildClassDefinition(ge, className);
        cursorClass.addMethods(CursorGenerator.buildConstructors(ge));
        if (ge instanceof DataGrainElement) {
            Set<Column> pk;
            List<FieldSpec> fieldSpecs = CursorGenerator.buildFields((DataGrainElement)ge);
            cursorClass.addFields(fieldSpecs);
            cursorClass.addMethods(CursorGenerator.generateGettersAndSetters(fieldSpecs));
            DataGrainElement dge = (DataGrainElement)ge;
            Map columns = dge.getColumns();
            cursorClass.addMethod(CursorGenerator.buildSetFieldValue());
            StringBuilder parseResultOverridingMethodNameBuilder = new StringBuilder("_parseResult");
            if (dge instanceof TableElement) {
                TableElement te = (TableElement)dge;
                if (te instanceof Table && ((Table)te).isReadOnly()) {
                    pk = Collections.emptySet();
                } else {
                    pk = new LinkedHashSet(te.getPrimaryKey().values());
                    cursorClass.addMethod(CursorGenerator.buildCurrentKeyValues(pk));
                    if (te instanceof Table) {
                        parseResultOverridingMethodNameBuilder.append("Internal");
                    }
                }
            } else {
                pk = Collections.emptySet();
            }
            MethodSpec buildParseResultMethod = CursorGenerator.buildParseResult(columns, parseResultOverridingMethodNameBuilder.toString(), isVersionedGe);
            cursorClass.addMethod(buildParseResultMethod);
            cursorClass.addMethod(CursorGenerator.buildClearBuffer(columns, pk));
            cursorClass.addMethod(CursorGenerator.buildCurrentValues(columns));
            if (dge instanceof Table) {
                Table t = (Table)dge;
                if (!t.isReadOnly()) {
                    cursorClass.addMethods(CursorGenerator.buildCalcBlobs(columns, className));
                    cursorClass.addMethod(CursorGenerator.buildSetAutoIncrement(columns));
                    cursorClass.addMethods(CursorGenerator.buildTriggerRegistration(className));
                }
                cursorClass.addTypes(CursorGenerator.buildOptionFieldsAsInnerStaticClasses(t.getColumns().values()));
            }
            cursorClass.addMethods(CursorGenerator.buildCompileCopying(ge, className, columns.keySet(), isVersionedGe));
            cursorClass.addMethod(CursorGenerator.buildIterator(className));
        }
        cursorClass.addMethods(CursorGenerator.buildGrainNameAndObjectName(ge));
        JavaFile javaFile = JavaFile.builder((String)sourcePackage, (TypeSpec)cursorClass.build()).skipJavaLangImports(true).indent("    ").build();
        try {
            javaFile.writeTo(srcDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String calcSourcePackage(GrainElement ge, String scorePath) {
        String result;
        Grain g = ge.getGrain();
        if (g.getName().equals(g.getScore().getSysSchemaName())) {
            result = "ru.curs.celesta.syscursors";
        } else {
            String grainPartPath = ge.getGrainPart().getSourceFile().getParentFile().getAbsolutePath();
            String grainPartRelativePath = grainPartPath.replace(scorePath, "");
            result = grainPartRelativePath.replace(File.separator, ".");
            if (result.startsWith(".")) {
                result = result.substring(1);
            }
        }
        return result;
    }

    private static String calcClassName(GrainElement ge, String sourceFileNamePrefix) {
        if (ge instanceof SequenceElement) {
            return sourceFileNamePrefix + "Sequence";
        }
        return sourceFileNamePrefix + "Cursor";
    }

    private static TypeSpec.Builder buildClassDefinition(GrainElement ge, String className) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((Type)GRAIN_ELEMENTS_TO_DATA_ACCESSORS.get(ge.getClass()).apply(ge));
        if (ge instanceof DataGrainElement) {
            ClassName selfTypeName = ClassName.bestGuess((String)className);
            builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Iterable.class), (TypeName[])new TypeName[]{selfTypeName}));
        }
        if (ge instanceof Table) {
            Table t = (Table)ge;
            if (!t.isReadOnly()) {
                t.getImplements().forEach(i -> builder.addSuperinterface((TypeName)ClassName.bestGuess((String)i)));
            }
            if (ge.getGrain().getName().equals(ge.getGrain().getScore().getSysSchemaName())) {
                builder.addField(FieldSpec.builder(String.class, (String)"TABLE_NAME", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{ge.getName()}).build());
            }
        }
        return builder;
    }

    private static List<TypeSpec> buildOptionFieldsAsInnerStaticClasses(Collection<Column> columns) {
        return columns.stream().filter(c -> (c instanceof IntegerColumn || c instanceof StringColumn) && !c.getOptions().isEmpty()).map(c -> {
            TypeSpec.Builder builder = TypeSpec.classBuilder((String)StringUtils.capitalize((String)c.getName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
            MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("throw new $T()", new Object[]{AssertionError.class}).build();
            builder.addMethod(constructor);
            List options = c.getOptions();
            builder.addFields((Iterable)options.stream().map(s -> {
                FieldSpec.Builder fb = FieldSpec.builder((Type)c.getJavaClass(), (String)s, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
                if (c instanceof IntegerColumn) {
                    fb.initializer("$L", new Object[]{options.indexOf(s)});
                } else {
                    fb.initializer("$S", new Object[]{s});
                }
                return fb.build();
            }).collect(Collectors.toList()));
            return builder.build();
        }).collect(Collectors.toList());
    }

    private static List<MethodSpec> buildConstructors(GrainElement ge) {
        ArrayList<MethodSpec> result = new ArrayList<MethodSpec>();
        ParameterSpec contextParam = ParameterSpec.builder(CallContext.class, (String)"context", (Modifier[])new Modifier[0]).build();
        ParameterSpec fieldsParam = ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Set.class, (Type[])new Type[]{String.class}), (String)"fields", (Modifier[])new Modifier[0]).build();
        ParameterSpec parametersParam = ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class}), (String)"parameters", (Modifier[])new Modifier[0]).build();
        Supplier<MethodSpec.Builder> msp = () -> MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(contextParam);
        MethodSpec.Builder builder = msp.get();
        if (ge instanceof ParameterizedView) {
            builder.addParameter(parametersParam);
            builder.addStatement("super(context, parameters)", new Object[0]);
        } else {
            builder.addStatement("super(context)", new Object[0]);
        }
        result.add(builder.build());
        if (ge instanceof SequenceElement) {
            return result;
        }
        builder = msp.get();
        if (ge instanceof ParameterizedView) {
            builder.addParameter(fieldsParam);
            builder.addParameter(parametersParam);
            builder.addStatement("super(context, fields, parameters)", new Object[0]);
        } else {
            builder.addParameter(fieldsParam);
            builder.addStatement("super(context, fields)", new Object[0]);
        }
        result.add(builder.build());
        return result;
    }

    private static List<MethodSpec> buildGrainNameAndObjectName(GrainElement ge) {
        MethodSpec grainName = MethodSpec.methodBuilder((String)"_grainName").addAnnotation(Override.class).returns(String.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addStatement("return $S", new Object[]{ge.getGrain().getName()}).build();
        MethodSpec objectName = MethodSpec.methodBuilder((String)"_objectName").addAnnotation(Override.class).returns(String.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addStatement("return $S", new Object[]{ge.getName()}).build();
        return Arrays.asList(grainName, objectName);
    }

    private static List<FieldSpec> buildFields(DataGrainElement ge) {
        Map columns = ge.getColumns();
        return columns.entrySet().stream().map(e -> FieldSpec.builder((Type)((ColumnMeta)e.getValue()).getJavaClass(), (String)((String)e.getKey()), (Modifier[])new Modifier[]{Modifier.PRIVATE})).map(FieldSpec.Builder::build).collect(Collectors.toList());
    }

    private static List<MethodSpec> generateGettersAndSetters(List<FieldSpec> fieldSpecs) {
        ArrayList<MethodSpec> result = new ArrayList<MethodSpec>();
        fieldSpecs.forEach(fieldSpec -> {
            String methodSuffix = String.valueOf(Character.toUpperCase(fieldSpec.name.charAt(0)));
            if (fieldSpec.name.length() > 1) {
                methodSuffix = methodSuffix + fieldSpec.name.substring(1);
            }
            MethodSpec getter = MethodSpec.methodBuilder((String)("get" + methodSuffix)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(fieldSpec.type).addStatement("return this.$N", new Object[]{fieldSpec.name}).build();
            MethodSpec setter = MethodSpec.methodBuilder((String)("set" + methodSuffix)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(fieldSpec.type, fieldSpec.name, new Modifier[0]).addStatement("this.$N = $N", new Object[]{fieldSpec.name, fieldSpec.name}).build();
            result.add(getter);
            result.add(setter);
        });
        return result;
    }

    private static MethodSpec buildParseResult(Map<String, ? extends ColumnMeta> columns, String methodName, boolean isVersionedObject) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addParameter(ResultSet.class, "rs", new Modifier[0]).addException(SQLException.class);
        columns.entrySet().forEach(entry -> {
            String name = (String)entry.getKey();
            ColumnMeta meta = (ColumnMeta)entry.getValue();
            if ("BLOB".equals(meta.getCelestaType())) {
                builder.addStatement("this.$N = null", new Object[]{name});
            } else {
                builder.beginControlFlow("if (this.$N($S))", new Object[]{"inRec", name});
                if ("DATETIME WITH TIME ZONE".equals(meta.getCelestaType())) {
                    builder.addStatement("$T ts = rs.$N($S, $T.getInstance($T.getTimeZone($S)))", new Object[]{Timestamp.class, meta.jdbcGetterName(), name, Calendar.class, TimeZone.class, "UTC"});
                    builder.beginControlFlow("if ($N != null)", new Object[]{"ts"});
                    builder.addStatement("this.$N = $T.of(ts.toLocalDateTime(), $T.systemDefault())", new Object[]{name, ZonedDateTime.class, ZoneOffset.class});
                    builder.endControlFlow();
                    builder.beginControlFlow("else", new Object[0]);
                    builder.addStatement("this.$N = null", new Object[]{name});
                    builder.endControlFlow();
                } else {
                    builder.addStatement("this.$N = rs.$N($S)", new Object[]{name, meta.jdbcGetterName(), name});
                }
                builder.endControlFlow();
            }
        });
        if (isVersionedObject) {
            builder.addStatement("this.setRecversion(rs.getInt($S))", new Object[]{"recversion"});
        }
        return builder.build();
    }

    private static MethodSpec buildSetFieldValue() {
        String nameParam = "name";
        String valueParam = "value";
        return MethodSpec.methodBuilder((String)"_setFieldValue").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(String.class, nameParam, new Modifier[0]).addParameter(Object.class, valueParam, new Modifier[0]).beginControlFlow("try", new Object[0]).addStatement("$T f = getClass().getDeclaredField($N)", new Object[]{Field.class, nameParam}).addStatement("f.setAccessible(true)", new Object[0]).addStatement("f.set(this, value)", new Object[0]).endControlFlow().beginControlFlow("catch ($T e)", new Object[]{Exception.class}).addStatement("throw new $T(e)", new Object[]{RuntimeException.class}).endControlFlow().build();
    }

    private static MethodSpec buildClearBuffer(Map<String, ? extends ColumnMeta> columns, Set<Column> pk) {
        ParameterSpec param = ParameterSpec.builder(Boolean.TYPE, (String)"withKeys", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"_clearBuffer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addParameter(param);
        if (!pk.isEmpty()) {
            builder.beginControlFlow("if ($N)", new Object[]{param.name});
            pk.stream().forEach(c -> builder.addStatement("this.$N = null", new Object[]{c.getName()}));
            builder.endControlFlow();
        }
        columns.entrySet().stream().filter(e -> !pk.contains(e.getValue())).forEach(e -> builder.addStatement("this.$N = null", new Object[]{e.getKey()}));
        return builder.build();
    }

    private static MethodSpec buildCurrentKeyValues(Set<Column> pk) {
        ArrayTypeName resultType = ArrayTypeName.of(Object.class);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"_currentKeyValues").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)resultType).addStatement("$T result = new Object[$L]", new Object[]{resultType, pk.size()});
        AtomicInteger counter = new AtomicInteger(0);
        pk.forEach(c -> builder.addStatement("result[$L] = this.$N", new Object[]{counter.getAndIncrement(), c.getName()}));
        builder.addStatement("return result", new Object[0]);
        return builder.build();
    }

    private static MethodSpec buildCurrentValues(Map<String, ? extends ColumnMeta> columns) {
        ArrayTypeName resultType = ArrayTypeName.of(Object.class);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"_currentValues").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)resultType).addStatement("$T result = new Object[$L]", new Object[]{resultType, columns.size()});
        AtomicInteger counter = new AtomicInteger(0);
        columns.forEach((name, c) -> builder.addStatement("result[$L] = this.$N", new Object[]{counter.getAndIncrement(), name}));
        builder.addStatement("return result", new Object[0]);
        return builder.build();
    }

    private static List<MethodSpec> buildCalcBlobs(Map<String, ? extends ColumnMeta> columns, String className) {
        return columns.entrySet().stream().filter(e -> e.getValue() instanceof BinaryColumn).map(e -> MethodSpec.methodBuilder((String)("calc" + StringUtils.capitalize((String)((String)e.getKey())))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.$N = this.calcBlob($S)", new Object[]{e.getKey(), e.getKey()}).addStatement("(($N)this.getXRec()).$N = this.$N.clone()", new Object[]{className, e.getKey(), e.getKey()}).build()).collect(Collectors.toList());
    }

    private static MethodSpec buildSetAutoIncrement(Map<String, ? extends ColumnMeta> columns) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"_setAutoIncrement").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class);
        ParameterSpec param = ParameterSpec.builder(Integer.TYPE, (String)"val", (Modifier[])new Modifier[0]).build();
        builder.addParameter(param);
        columns.entrySet().stream().filter(e -> e.getValue() instanceof IntegerColumn && ((IntegerColumn)e.getValue()).isIdentity()).findFirst().ifPresent(e -> builder.addStatement("this.$N = $N", new Object[]{e.getKey(), param.name}));
        return builder.build();
    }

    private static List<MethodSpec> buildTriggerRegistration(String className) {
        ClassName selfTypeName = ClassName.bestGuess((String)className);
        ParameterSpec celestaParam = ParameterSpec.builder(ICelesta.class, (String)"celesta", (Modifier[])new Modifier[0]).build();
        ParameterSpec consumerParam = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{selfTypeName}), (String)"cursorConsumer", (Modifier[])new Modifier[0]).build();
        return TRIGGER_REGISTRATION_METHOD_TO_TRIGGER_TYPE.entrySet().stream().map(arg_0 -> CursorGenerator.lambda$buildTriggerRegistration$22(celestaParam, consumerParam, (TypeName)selfTypeName, arg_0)).collect(Collectors.toList());
    }

    private static List<MethodSpec> buildCompileCopying(GrainElement ge, String className, Collection<String> columns, boolean isVersionedObject) {
        String copyFieldsFromMethodName = "copyFieldsFrom";
        ParameterSpec context = ParameterSpec.builder(CallContext.class, (String)"context", (Modifier[])new Modifier[0]).build();
        ParameterSpec fields = ParameterSpec.builder((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class}), (String)"fields", (Modifier[])new Modifier[0]).build();
        ClassName selfTypeName = ClassName.bestGuess((String)className);
        MethodSpec.Builder getBufferCopyBuilder = MethodSpec.methodBuilder((String)"_getBufferCopy").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameters(Arrays.asList(context, fields)).returns((TypeName)selfTypeName).addStatement("final $T result", new Object[]{selfTypeName}).beginControlFlow("if ($T.isNull($N))", new Object[]{Objects.class, fields.name});
        if (ge instanceof ParameterizedView) {
            getBufferCopyBuilder.addStatement("result = new $T($N, this.parameters)", new Object[]{selfTypeName, context.name});
        } else {
            getBufferCopyBuilder.addStatement("result = new $T($N)", new Object[]{selfTypeName, context.name});
        }
        getBufferCopyBuilder.endControlFlow().beginControlFlow("else", new Object[0]);
        if (ge instanceof ParameterizedView) {
            getBufferCopyBuilder.addStatement("result = new $T($N, new $T<>($N), this.parameters)", new Object[]{selfTypeName, context.name, LinkedHashSet.class, fields.name});
        } else {
            getBufferCopyBuilder.addStatement("result = new $T($N, new $T<>($N))", new Object[]{selfTypeName, context.name, LinkedHashSet.class, fields.name});
        }
        getBufferCopyBuilder.endControlFlow().addStatement("result.$N(this)", new Object[]{"copyFieldsFrom"}).addStatement("return result", new Object[0]);
        MethodSpec getBufferCopy = getBufferCopyBuilder.build();
        MethodSpec.Builder copyFieldsFromBuilder = MethodSpec.methodBuilder((String)"copyFieldsFrom").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(BasicCursor.class, "c", new Modifier[0]);
        copyFieldsFromBuilder.addStatement("$T from = ($T)c", new Object[]{selfTypeName, selfTypeName});
        columns.forEach(c -> copyFieldsFromBuilder.addStatement("this.$N = from.$N", new Object[]{c, c}));
        if (isVersionedObject) {
            copyFieldsFromBuilder.addStatement("this.setRecversion(from.getRecversion())", new Object[0]);
        }
        return Arrays.asList(getBufferCopy, copyFieldsFromBuilder.build());
    }

    private static MethodSpec buildIterator(String className) {
        ClassName selfTypeName = ClassName.bestGuess((String)className);
        ParameterizedTypeName iteratorTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Iterator.class), (TypeName[])new TypeName[]{selfTypeName});
        ParameterizedTypeName cursorIterator = ParameterizedTypeName.get((ClassName)ClassName.get(CursorIterator.class), (TypeName[])new TypeName[]{selfTypeName});
        return MethodSpec.methodBuilder((String)"iterator").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)iteratorTypeName).addStatement("return new $T(this)", new Object[]{cursorIterator}).build();
    }

    private static /* synthetic */ MethodSpec lambda$buildTriggerRegistration$22(ParameterSpec celestaParam, ParameterSpec consumerParam, TypeName selfTypeName, Map.Entry e) {
        String methodName = (String)e.getKey();
        String triggerType = (String)e.getValue();
        return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(celestaParam).addParameter(consumerParam).addStatement("$N.getTriggerDispatcher().registerTrigger($T.$N, $T.class, $N)", new Object[]{celestaParam.name, TriggerType.class, triggerType, selfTypeName, consumerParam.name}).build();
    }

    static {
        GRAIN_ELEMENTS_TO_DATA_ACCESSORS.put(SequenceElement.class, ge -> Sequence.class);
        GRAIN_ELEMENTS_TO_DATA_ACCESSORS.put(Table.class, ge -> {
            Table t = (Table)ge;
            if (t.isReadOnly()) {
                return ReadOnlyTableCursor.class;
            }
            return Cursor.class;
        });
        GRAIN_ELEMENTS_TO_DATA_ACCESSORS.put(View.class, ge -> ViewCursor.class);
        GRAIN_ELEMENTS_TO_DATA_ACCESSORS.put(MaterializedView.class, ge -> MaterializedViewCursor.class);
        GRAIN_ELEMENTS_TO_DATA_ACCESSORS.put(ParameterizedView.class, ge -> ParameterizedViewCursor.class);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("onPreDelete", "PRE_DELETE");
        map.put("onPostDelete", "POST_DELETE");
        map.put("onPreInsert", "PRE_INSERT");
        map.put("onPostInsert", "POST_INSERT");
        map.put("onPreUpdate", "PRE_UPDATE");
        map.put("onPostUpdate", "POST_UPDATE");
        TRIGGER_REGISTRATION_METHOD_TO_TRIGGER_TYPE = Collections.unmodifiableMap(map);
    }
}

