/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.plugin.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import ru.curs.celesta.plugin.maven.AbstractCelestaMojo;
import ru.curs.celesta.plugin.maven.ScoreProperties;
import ru.curs.celesta.score.Score;
import ru.curs.celesta.score.io.FileResource;
import ru.curs.celesta.score.io.Resource;

abstract class AbstractGenScoreResourcesMojo
extends AbstractCelestaMojo {
    static final String SCORE_FILES_FILE_NAME = "score.files";
    Supplier<Collection<ScoreProperties>> getScorePaths;
    String generatedResourcesDirName;
    Consumer<org.apache.maven.model.Resource> addResource;

    AbstractGenScoreResourcesMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("celesta project is " + this.project));
        ArrayList<GrainSourceBag> grainsSources = new ArrayList<GrainSourceBag>();
        for (ScoreProperties sp : this.getScorePaths.get()) {
            Score score = this.initScore(sp.getPath());
            FileResource scoreSource = new FileResource(new File(sp.getPath()));
            score.getGrains().values().stream().filter(this::isAllowGrain).flatMap(g -> g.getGrainParts().stream()).map(gp -> gp.getSource()).filter(Objects::nonNull).forEach(arg_0 -> AbstractGenScoreResourcesMojo.lambda$execute$2(grainsSources, (Resource)scoreSource, arg_0));
        }
        if (grainsSources.isEmpty()) {
            return;
        }
        this.copyGrainSourceFilesToResources(grainsSources);
        this.generateScoreFiles(grainsSources);
        org.apache.maven.model.Resource scoreResource = new org.apache.maven.model.Resource();
        scoreResource.setDirectory(this.getResourcesRoot().getAbsolutePath());
        scoreResource.setTargetPath("score");
        this.addResource.accept(scoreResource);
    }

    private void copyGrainSourceFilesToResources(Collection<GrainSourceBag> grainSources) throws MojoExecutionException {
        Path resourcesRootPath = this.getResourcesRoot().toPath();
        for (GrainSourceBag gs : grainSources) {
            Path to = gs.resolve(resourcesRootPath);
            try {
                if (to == null) continue;
                Path toParent = to.getParent();
                if (toParent != null) {
                    Files.createDirectories(toParent, new FileAttribute[0]);
                }
                Files.copy(gs.grainSource.getInputStream(), to, new CopyOption[0]);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(String.format("Copying of grain source file failed: %s", gs.grainSource), (Exception)ex);
            }
        }
    }

    private File getResourcesRoot() {
        return new File(this.project.getBuild().getDirectory() + File.separator + this.generatedResourcesDirName + File.separator + "score");
    }

    private void generateScoreFiles(List<GrainSourceBag> grainsSources) throws MojoExecutionException {
        Collection relativeSourcesPaths = grainsSources.stream().map(gs -> gs.getGrainSourceRelativePath().toString()).collect(Collectors.toCollection(TreeSet::new));
        Path scoreFilesPath = new File(this.getResourcesRoot(), SCORE_FILES_FILE_NAME).toPath();
        try {
            Files.write(scoreFilesPath, (Iterable<? extends CharSequence>)relativeSourcesPaths, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error writing a score.files", (Exception)ex);
        }
    }

    private static /* synthetic */ void lambda$execute$2(List grainsSources, Resource scoreSource, Resource s) {
        grainsSources.add(new GrainSourceBag(scoreSource, s));
    }

    private static class GrainSourceBag {
        final Resource scoreSource;
        final Resource grainSource;

        GrainSourceBag(Resource scoreSource, Resource grainSource) {
            this.scoreSource = scoreSource;
            this.grainSource = grainSource;
        }

        Path resolve(Path rootPath) {
            return rootPath.resolve(this.getGrainSourceRelativePath());
        }

        Path getGrainSourceRelativePath() {
            return new File(this.scoreSource.getRelativePath(this.grainSource)).toPath();
        }
    }
}

