/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.tools.Server;
import ru.curs.celesta.BaseAppSettings;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.ConnectionPoolConfiguration;
import ru.curs.celesta.CurrentScore;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.SessionContext;
import ru.curs.celesta.dbutils.DbUpdaterBuilder;
import ru.curs.celesta.dbutils.DbUpdaterImpl;
import ru.curs.celesta.dbutils.ILoggingManager;
import ru.curs.celesta.dbutils.IPermissionManager;
import ru.curs.celesta.dbutils.LoggingManager;
import ru.curs.celesta.dbutils.PermissionManager;
import ru.curs.celesta.dbutils.ProfilingManager;
import ru.curs.celesta.dbutils.SessionLogManager;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.configuration.DbAdaptorFactory;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;
import ru.curs.celesta.dbutils.adaptors.ddl.JdbcDdlConsumer;
import ru.curs.celesta.event.TriggerDispatcher;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.Score;
import ru.curs.celesta.score.discovery.ScoreDiscovery;

public abstract class AbstractCelesta<T extends SessionContext>
implements ICelesta,
AutoCloseable {
    protected static final String FILE_PROPERTIES = "celesta.properties";
    private final BaseAppSettings appSettings;
    private final Score score;
    final ConnectionPool connectionPool;
    final DBAdaptor dbAdaptor;
    private final Optional<SessionLogManager> sessionLogManager;
    private final TriggerDispatcher triggerDispatcher = new TriggerDispatcher();
    private Optional<Server> server;
    final LoggingManager loggingManager;
    final PermissionManager permissionManager;
    final ProfilingManager profiler;
    protected final ConcurrentHashMap<String, T> sessions = new ConcurrentHashMap();
    final Set<CallContext> contexts = Collections.synchronizedSet(new LinkedHashSet());

    public AbstractCelesta(BaseAppSettings appSettings, int phasesCount) {
        this.appSettings = appSettings;
        this.manageH2Server();
        System.out.printf("Celesta initialization: phase 1/%s score parsing...", phasesCount);
        try {
            this.score = (Score)new AbstractScore.ScoreBuilder(Score.class).path(appSettings.getScorePath()).scoreDiscovery(this.getScoreDiscovery()).build();
        }
        catch (ParseException e) {
            throw new CelestaException((Throwable)e);
        }
        CurrentScore.set((AbstractScore)this.score);
        System.out.println("done.");
        ConnectionPoolConfiguration cpc = new ConnectionPoolConfiguration();
        cpc.setJdbcConnectionUrl(appSettings.getDatabaseConnection());
        cpc.setDriverClassName(appSettings.getDbClassName());
        cpc.setLogin(appSettings.getDBLogin());
        cpc.setPassword(appSettings.getDBPassword());
        this.connectionPool = ConnectionPool.create((ConnectionPoolConfiguration)cpc);
        DbAdaptorFactory dac = new DbAdaptorFactory().setDbType(appSettings.getDBType()).setDdlConsumer((DdlConsumer)new JdbcDdlConsumer()).setConnectionPool(this.connectionPool).setH2ReferentialIntegrity(appSettings.isH2ReferentialIntegrity());
        this.dbAdaptor = dac.createDbAdaptor();
        this.sessionLogManager = appSettings.getLogLogins() ? Optional.of(new SessionLogManager(this, appSettings.getLogLogins())) : Optional.empty();
        this.loggingManager = new LoggingManager(this, this.dbAdaptor);
        this.permissionManager = new PermissionManager(this, this.dbAdaptor);
        this.profiler = new ProfilingManager(this, this.dbAdaptor);
        if (!appSettings.getSkipDBUpdate()) {
            System.out.printf("Celesta initialization: phase 2/%s database upgrade...", phasesCount);
            DbUpdaterImpl dbUpdater = new DbUpdaterBuilder().dbAdaptor(this.dbAdaptor).connectionPool(this.connectionPool).score(this.score).forceDdInitialize(appSettings.getForceDBInitialize()).setCelesta(this).setPermissionManager(this.permissionManager).setLoggingManager(this.loggingManager).build();
            dbUpdater.updateDb();
            System.out.println("done.");
        } else {
            System.out.printf("Celesta initialization: phase 2/%s database upgrade...skipped.%n", phasesCount);
        }
    }

    public void login(String sessionId, String userId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("Session id is null.");
        }
        if (userId == null) {
            throw new IllegalArgumentException("User id is null.");
        }
        SessionContext oldSession = (SessionContext)this.sessions.get(sessionId);
        if (oldSession == null || !userId.equals(oldSession.getUserId())) {
            Object session = this.sessionContext(userId, sessionId);
            this.sessions.put(sessionId, session);
            this.sessionLogManager.ifPresent(s -> s.logLogin((SessionContext)session));
        }
    }

    public T logout(String sessionId, boolean timeout) {
        SessionContext sc = (SessionContext)this.sessions.remove(sessionId);
        if (sc != null) {
            this.sessionLogManager.ifPresent(s -> s.logLogout(sc, timeout));
        }
        return (T)sc;
    }

    public void failedLogin(String userId) {
        this.sessionLogManager.ifPresent(s -> s.logFailedLogin(userId));
    }

    public Collection<CallContext> getActiveContexts() {
        return Collections.unmodifiableCollection(this.contexts);
    }

    public Properties getSetupProperties() {
        return this.appSettings.getSetupProperties();
    }

    public TriggerDispatcher getTriggerDispatcher() {
        return this.triggerDispatcher;
    }

    public Score getScore() {
        return this.score;
    }

    @Override
    public void close() {
        this.connectionPool.close();
        this.server.ifPresent(Server::shutdown);
    }

    protected abstract ScoreDiscovery getScoreDiscovery();

    public abstract T getSystemSessionContext();

    protected abstract T sessionContext(String var1, String var2);

    protected T getSessionContext(String sessionId) {
        SessionContext result = (SessionContext)this.sessions.get(sessionId);
        if (result == null) {
            throw new CelestaException("Session ID=%s is not logged in", new Object[]{sessionId});
        }
        return (T)result;
    }

    public CallContext callContext(T sessionContext) {
        return sessionContext.callContextBuilder().setCelesta((ICelesta)this).setConnectionPool(this.connectionPool).setSesContext(sessionContext).setScore(this.score).setDbAdaptor(this.dbAdaptor).setPermissionManager((IPermissionManager)this.permissionManager).setLoggingManager((ILoggingManager)this.loggingManager).createCallContext();
    }

    public CallContext callContext() {
        return this.callContext(this.getSystemSessionContext());
    }

    private void manageH2Server() {
        if (this.appSettings.getH2Port() > 0) {
            try {
                System.out.printf("H2 server starting on port %d...", this.appSettings.getH2Port());
                this.server = Optional.of(Server.createTcpServer((String[])new String[]{"-tcpPort", Integer.toString(this.appSettings.getH2Port()), "-tcpAllowOthers"}).start());
                System.out.println("done.");
                CurrentScore.global((boolean)true);
            }
            catch (SQLException e) {
                throw new CelestaException((Throwable)e);
            }
        } else {
            this.server = Optional.empty();
            CurrentScore.global((boolean)false);
        }
    }
}

