/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.util.Date;
import ru.curs.celesta.AbstractCelesta;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.SessionContext;
import ru.curs.celesta.syscursors.SessionlogCursor;

public final class SessionLogManager {
    private final AbstractCelesta celesta;
    private final boolean enabled;

    public SessionLogManager(AbstractCelesta celesta, boolean enabled) {
        this.celesta = celesta;
        this.enabled = enabled;
    }

    public void logLogin(SessionContext session) {
        if (!this.enabled) {
            return;
        }
        try (CallContext context = this.celesta.callContext();){
            SessionlogCursor sl = new SessionlogCursor(context);
            sl.init();
            sl.setSessionid(session.getSessionId());
            sl.setUserid(session.getUserId());
            sl.insert();
        }
    }

    public void logFailedLogin(String userId) {
        if (!this.enabled) {
            return;
        }
        try (CallContext context = this.celesta.callContext();){
            SessionlogCursor sl = new SessionlogCursor(context);
            sl.init();
            sl.setUserid(userId);
            sl.setFailedlogin(true);
            sl.insert();
        }
    }

    public void logLogout(SessionContext session, boolean timeout) {
        if (!this.enabled) {
            return;
        }
        try (CallContext context = this.celesta.callContext();){
            SessionlogCursor sl = new SessionlogCursor(context);
            sl.init();
            sl.setRange("sessionid", session.getSessionId());
            sl.setRange("userid", session.getUserId());
            sl.orderBy(new String[]{"entryno DESC"});
            if (sl.tryFirst()) {
                sl.setLogoutime(new Date());
                sl.setTimeout(timeout);
                sl.update();
            }
        }
    }
}

