/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.h2.tools.Server;
import ru.curs.celesta.AppSettings;
import ru.curs.celesta.BaseAppSettings;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.ConnectionPoolConfiguration;
import ru.curs.celesta.CurrentScore;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.DbUpdaterBuilder;
import ru.curs.celesta.dbutils.DbUpdaterImpl;
import ru.curs.celesta.dbutils.ILoggingManager;
import ru.curs.celesta.dbutils.IPermissionManager;
import ru.curs.celesta.dbutils.IProfiler;
import ru.curs.celesta.dbutils.LoggingManager;
import ru.curs.celesta.dbutils.PermissionManager;
import ru.curs.celesta.dbutils.ProfilingManager;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.configuration.DbAdaptorFactory;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;
import ru.curs.celesta.dbutils.adaptors.ddl.JdbcDdlConsumer;
import ru.curs.celesta.event.TriggerDispatcher;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.Score;
import ru.curs.celesta.score.discovery.DefaultScoreDiscovery;
import ru.curs.celesta.score.discovery.ScoreDiscovery;

public final class Celesta
implements ICelesta {
    protected static final String FILE_PROPERTIES = "celesta.properties";
    private final BaseAppSettings appSettings;
    private final Score score;
    private final ConnectionPool connectionPool;
    private final DBAdaptor dbAdaptor;
    private final TriggerDispatcher triggerDispatcher = new TriggerDispatcher();
    private final ScoreDiscovery scoreDiscovery = new DefaultScoreDiscovery();
    private Optional<Server> server;
    private final LoggingManager loggingManager;
    private final PermissionManager permissionManager;
    private final ProfilingManager profiler;
    private final Set<CallContext> contexts = Collections.synchronizedSet(new LinkedHashSet());

    public Celesta(BaseAppSettings appSettings) {
        this.appSettings = appSettings;
        this.manageH2Server();
        System.out.printf("Celesta initialization: score parsing...", new Object[0]);
        try {
            this.score = (Score)new AbstractScore.ScoreBuilder(Score.class).path(appSettings.getScorePath()).scoreDiscovery(this.getScoreDiscovery()).build();
        }
        catch (ParseException e) {
            throw new CelestaException((Throwable)e);
        }
        CurrentScore.set((AbstractScore)this.score);
        System.out.println("done.");
        ConnectionPoolConfiguration cpc = new ConnectionPoolConfiguration();
        cpc.setJdbcConnectionUrl(appSettings.getDatabaseConnection());
        cpc.setDriverClassName(appSettings.getDbClassName());
        cpc.setLogin(appSettings.getDBLogin());
        cpc.setPassword(appSettings.getDBPassword());
        this.connectionPool = ConnectionPool.create((ConnectionPoolConfiguration)cpc);
        DbAdaptorFactory dac = new DbAdaptorFactory().setDbType(appSettings.getDBType()).setDdlConsumer((DdlConsumer)new JdbcDdlConsumer()).setConnectionPool(this.connectionPool).setH2ReferentialIntegrity(appSettings.isH2ReferentialIntegrity());
        this.dbAdaptor = dac.createDbAdaptor();
        this.loggingManager = new LoggingManager(this, this.dbAdaptor);
        this.permissionManager = new PermissionManager(this, this.dbAdaptor);
        this.profiler = new ProfilingManager(this, this.dbAdaptor);
        if (!appSettings.getSkipDBUpdate()) {
            System.out.printf("Celesta initialization: database upgrade...", new Object[0]);
            DbUpdaterImpl dbUpdater = new DbUpdaterBuilder().dbAdaptor(this.dbAdaptor).connectionPool(this.connectionPool).score(this.score).forceDdInitialize(appSettings.getForceDBInitialize()).setCelesta(this).setPermissionManager(this.permissionManager).setLoggingManager(this.loggingManager).build();
            dbUpdater.updateDb();
            System.out.println("done.");
        } else {
            System.out.printf("Celesta initialization: database upgrade...skipped.%n", new Object[0]);
        }
    }

    public Collection<CallContext> getActiveContexts() {
        return Collections.unmodifiableCollection(this.contexts);
    }

    public Properties getSetupProperties() {
        return this.appSettings.getSetupProperties();
    }

    public IPermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public ILoggingManager getLoggingManager() {
        return this.loggingManager;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public IProfiler getProfiler() {
        return this.profiler;
    }

    public DBAdaptor getDBAdaptor() {
        return this.dbAdaptor;
    }

    public TriggerDispatcher getTriggerDispatcher() {
        return this.triggerDispatcher;
    }

    public Score getScore() {
        return this.score;
    }

    public void close() {
        this.connectionPool.close();
        this.server.ifPresent(Server::shutdown);
    }

    public static Celesta createInstance(Properties properties) {
        AppSettings appSettings = Celesta.preInit(properties);
        return new Celesta(appSettings);
    }

    public static Celesta createInstance() {
        Properties properties = Celesta.loadPropertiesDynamically();
        return Celesta.createInstance(properties);
    }

    private static AppSettings preInit(Properties properties) {
        System.out.print("Celesta pre-initialization: system settings reading...");
        AppSettings appSettings = new AppSettings(properties);
        System.out.println("done.");
        return appSettings;
    }

    public static Properties loadPropertiesDynamically() {
        Properties properties = new Properties();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream in = loader.getResourceAsStream(FILE_PROPERTIES);
            if (in == null) {
                throw new CelestaException(String.format("Couldn't find file %s on classpath.", FILE_PROPERTIES));
            }
            try {
                properties.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw new CelestaException(String.format("IOException while reading %s file: %s", FILE_PROPERTIES, e.getMessage()));
        }
        return properties;
    }

    protected ScoreDiscovery getScoreDiscovery() {
        return this.scoreDiscovery;
    }

    private void manageH2Server() {
        if (this.appSettings.getH2Port() > 0) {
            try {
                System.out.printf("H2 server starting on port %d...", this.appSettings.getH2Port());
                this.server = Optional.of(Server.createTcpServer((String[])new String[]{"-tcpPort", Integer.toString(this.appSettings.getH2Port()), "-tcpAllowOthers"}).start());
                System.out.println("done.");
                CurrentScore.global((boolean)true);
            }
            catch (SQLException e) {
                throw new CelestaException((Throwable)e);
            }
        } else {
            this.server = Optional.empty();
            CurrentScore.global((boolean)false);
        }
    }

    public boolean isProfilemode() {
        return this.profiler.isProfilemode();
    }

    public boolean nullsFirst() {
        return this.dbAdaptor.nullsFirst();
    }

    public void setProfilemode(boolean profilemode) {
        this.profiler.setProfilemode(profilemode);
    }
}

