/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import ru.curs.celesta.BaseAppSettings;

public class AppSettings
extends BaseAppSettings {
    private final Set<String> celestaScan;

    public AppSettings(Properties properties) {
        super(properties);
        this.celestaScan = AppSettings.extractCelestaScanFromProperties(properties);
    }

    public static Set<String> extractCelestaScanFromProperties(Properties properties) {
        String celestaScanProperty = properties.getProperty("celestaScan");
        LinkedHashSet celestaScanVar = new LinkedHashSet();
        if (celestaScanProperty != null) {
            Arrays.stream(celestaScanProperty.split(",")).map(String::trim).forEach(celestaScanVar::add);
        }
        return Collections.unmodifiableSet(celestaScanVar);
    }

    public Set<String> getCelestaScan() {
        return this.celestaScan;
    }
}

