package ru.curs.celesta.syscursors;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;

public final class CalllogCursor extends Cursor implements Iterable<CalllogCursor> {
    public static final String TABLE_NAME = "calllog";

    private Integer entryno;

    private String sessionid;

    private String userid;

    private String procname;

    private Date starttime;

    private Integer duration;

    public CalllogCursor(CallContext context) {
        super(context);
    }

    public CalllogCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public Integer getEntryno() {
        return this.entryno;
    }

    public void setEntryno(Integer entryno) {
        this.entryno = entryno;
    }

    public String getSessionid() {
        return this.sessionid;
    }

    public void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getProcname() {
        return this.procname;
    }

    public void setProcname(String procname) {
        this.procname = procname;
    }

    public Date getStarttime() {
        return this.starttime;
    }

    public void setStarttime(Date starttime) {
        this.starttime = starttime;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            f.set(this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        Object[] result = new Object[1];
        result[0] = this.entryno;
        return result;
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("entryno")) {
            this.entryno = rs.getInt("entryno");
            if (rs.wasNull()) {
                this.entryno = null;
            }
        }
        if (this.inRec("sessionid")) {
            this.sessionid = rs.getString("sessionid");
            if (rs.wasNull()) {
                this.sessionid = null;
            }
        }
        if (this.inRec("userid")) {
            this.userid = rs.getString("userid");
            if (rs.wasNull()) {
                this.userid = null;
            }
        }
        if (this.inRec("procname")) {
            this.procname = rs.getString("procname");
            if (rs.wasNull()) {
                this.procname = null;
            }
        }
        if (this.inRec("starttime")) {
            this.starttime = rs.getTimestamp("starttime");
            if (rs.wasNull()) {
                this.starttime = null;
            }
        }
        if (this.inRec("duration")) {
            this.duration = rs.getInt("duration");
            if (rs.wasNull()) {
                this.duration = null;
            }
        }
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.entryno = null;
        }
        this.sessionid = null;
        this.userid = null;
        this.procname = null;
        this.starttime = null;
        this.duration = null;
    }

    @Override
    public Object[] _currentValues() {
        Object[] result = new Object[6];
        result[0] = this.entryno;
        result[1] = this.sessionid;
        result[2] = this.userid;
        result[3] = this.procname;
        result[4] = this.starttime;
        result[5] = this.duration;
        return result;
    }

    @Override
    protected void _setAutoIncrement(int val) {
        this.entryno = val;
    }

    public static void onPreDelete(ICelesta celesta, Consumer<CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, CalllogCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta, Consumer<CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, CalllogCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta, Consumer<CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, CalllogCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta, Consumer<CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, CalllogCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta, Consumer<CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, CalllogCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta, Consumer<CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, CalllogCursor.class, cursorConsumer);
    }

    @Override
    public CalllogCursor _getBufferCopy(CallContext context, List<String> fields) {
        final CalllogCursor result;
        if (Objects.isNull(fields)) {
            result = new CalllogCursor(context);
        }
        else {
            result = new CalllogCursor(context, new LinkedHashSet<>(fields));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        CalllogCursor from = (CalllogCursor)c;
        this.entryno = from.entryno;
        this.sessionid = from.sessionid;
        this.userid = from.userid;
        this.procname = from.procname;
        this.starttime = from.starttime;
        this.duration = from.duration;
    }

    @Override
    public Iterator<CalllogCursor> iterator() {
        return new CursorIterator<CalllogCursor>(this);
    }

    @Override
    protected String _grainName() {
        return "celesta";
    }

    @Override
    protected String _objectName() {
        return "calllog";
    }
}
