package ru.curs.celesta.syscursors;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;

public final class UserrolesCursor extends Cursor implements Iterable<UserrolesCursor> {
    public static final String TABLE_NAME = "userroles";

    private String userid;

    private String roleid;

    public UserrolesCursor(CallContext context) {
        super(context);
    }

    public UserrolesCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getRoleid() {
        return this.roleid;
    }

    public void setRoleid(String roleid) {
        this.roleid = roleid;
    }

    @Override
    protected Object _getFieldValue(String name) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            return f.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            f.set(this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        Object[] result = new Object[2];
        result[0] = this.userid;
        result[1] = this.roleid;
        return result;
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("userid")) {
            this.userid = rs.getString("userid");
            if (rs.wasNull()) {
                this.userid = null;
            }
        }
        if (this.inRec("roleid")) {
            this.roleid = rs.getString("roleid");
            if (rs.wasNull()) {
                this.roleid = null;
            }
        }
        this.setRecversion(rs.getInt("recversion"));
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.userid = null;
            this.roleid = null;
        }
    }

    @Override
    public Object[] _currentValues() {
        Object[] result = new Object[2];
        result[0] = this.userid;
        result[1] = this.roleid;
        return result;
    }

    @Override
    protected void _setAutoIncrement(int val) {
    }

    public static void onPreDelete(ICelesta celesta, Consumer<UserrolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, UserrolesCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta, Consumer<UserrolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, UserrolesCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta, Consumer<UserrolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, UserrolesCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta, Consumer<UserrolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, UserrolesCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta, Consumer<UserrolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, UserrolesCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta, Consumer<UserrolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, UserrolesCursor.class, cursorConsumer);
    }

    @Override
    public UserrolesCursor _getBufferCopy(CallContext context, List<String> fields) {
        final UserrolesCursor result;
        if (Objects.isNull(fields)) {
            result = new UserrolesCursor(context);
        }
        else {
            result = new UserrolesCursor(context, new LinkedHashSet<>(fields));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        UserrolesCursor from = (UserrolesCursor)c;
        this.userid = from.userid;
        this.roleid = from.roleid;
        this.setRecversion(from.getRecversion());
    }

    @Override
    public Iterator<UserrolesCursor> iterator() {
        return new CursorIterator<UserrolesCursor>(this);
    }

    @Override
    protected String _grainName() {
        return "celesta";
    }

    @Override
    protected String _objectName() {
        return "userroles";
    }
}
