package ru.curs.celesta.syscursors;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Generated;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.Table;

@Generated(
        value = "ru.curs.celesta.plugin.maven.CursorGenerator",
        date = "2020-03-01T00:38:06.989"
)
public final class LogCursor extends Cursor implements Iterable<LogCursor> {
    private static final String GRAIN_NAME = "celesta";

    private static final String OBJECT_NAME = "log";

    public static final String TABLE_NAME = OBJECT_NAME;

    public final LogCursor.Columns COLUMNS;

    private Integer entryno;

    private Date entry_time;

    private String userid;

    private String sessionid;

    private String grainid;

    private String tablename;

    private String action_type;

    private String pkvalue1;

    private String pkvalue2;

    private String pkvalue3;

    private String oldvalues;

    private String newvalues;

    {
        this.COLUMNS = new LogCursor.Columns(callContext().getCelesta());
    }

    public LogCursor(CallContext context) {
        super(context);
    }

    public LogCursor(CallContext context, ColumnMeta<?>... columns) {
        super(context, columns);
    }

    @Deprecated
    public LogCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public Integer getEntryno() {
        return this.entryno;
    }

    public void setEntryno(Integer entryno) {
        this.entryno = entryno;
    }

    public Date getEntry_time() {
        return this.entry_time;
    }

    public void setEntry_time(Date entry_time) {
        this.entry_time = entry_time;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getSessionid() {
        return this.sessionid;
    }

    public void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public String getGrainid() {
        return this.grainid;
    }

    public void setGrainid(String grainid) {
        this.grainid = grainid;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getAction_type() {
        return this.action_type;
    }

    public void setAction_type(String action_type) {
        this.action_type = action_type;
    }

    public String getPkvalue1() {
        return this.pkvalue1;
    }

    public void setPkvalue1(String pkvalue1) {
        this.pkvalue1 = pkvalue1;
    }

    public String getPkvalue2() {
        return this.pkvalue2;
    }

    public void setPkvalue2(String pkvalue2) {
        this.pkvalue2 = pkvalue2;
    }

    public String getPkvalue3() {
        return this.pkvalue3;
    }

    public void setPkvalue3(String pkvalue3) {
        this.pkvalue3 = pkvalue3;
    }

    public String getOldvalues() {
        return this.oldvalues;
    }

    public void setOldvalues(String oldvalues) {
        this.oldvalues = oldvalues;
    }

    public String getNewvalues() {
        return this.newvalues;
    }

    public void setNewvalues(String newvalues) {
        this.newvalues = newvalues;
    }

    @Override
    protected Object _getFieldValue(String name) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            return f.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            f.set(this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        Object[] result = new Object[1];
        result[0] = this.entryno;
        return result;
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("entryno")) {
            this.entryno = rs.getInt("entryno");
            if (rs.wasNull()) {
                this.entryno = null;
            }
        }
        if (this.inRec("entry_time")) {
            this.entry_time = rs.getTimestamp("entry_time");
            if (rs.wasNull()) {
                this.entry_time = null;
            }
        }
        if (this.inRec("userid")) {
            this.userid = rs.getString("userid");
            if (rs.wasNull()) {
                this.userid = null;
            }
        }
        if (this.inRec("sessionid")) {
            this.sessionid = rs.getString("sessionid");
            if (rs.wasNull()) {
                this.sessionid = null;
            }
        }
        if (this.inRec("grainid")) {
            this.grainid = rs.getString("grainid");
            if (rs.wasNull()) {
                this.grainid = null;
            }
        }
        if (this.inRec("tablename")) {
            this.tablename = rs.getString("tablename");
            if (rs.wasNull()) {
                this.tablename = null;
            }
        }
        if (this.inRec("action_type")) {
            this.action_type = rs.getString("action_type");
            if (rs.wasNull()) {
                this.action_type = null;
            }
        }
        if (this.inRec("pkvalue1")) {
            this.pkvalue1 = rs.getString("pkvalue1");
            if (rs.wasNull()) {
                this.pkvalue1 = null;
            }
        }
        if (this.inRec("pkvalue2")) {
            this.pkvalue2 = rs.getString("pkvalue2");
            if (rs.wasNull()) {
                this.pkvalue2 = null;
            }
        }
        if (this.inRec("pkvalue3")) {
            this.pkvalue3 = rs.getString("pkvalue3");
            if (rs.wasNull()) {
                this.pkvalue3 = null;
            }
        }
        if (this.inRec("oldvalues")) {
            this.oldvalues = rs.getString("oldvalues");
            if (rs.wasNull()) {
                this.oldvalues = null;
            }
        }
        if (this.inRec("newvalues")) {
            this.newvalues = rs.getString("newvalues");
            if (rs.wasNull()) {
                this.newvalues = null;
            }
        }
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.entryno = null;
        }
        this.entry_time = null;
        this.userid = null;
        this.sessionid = null;
        this.grainid = null;
        this.tablename = null;
        this.action_type = null;
        this.pkvalue1 = null;
        this.pkvalue2 = null;
        this.pkvalue3 = null;
        this.oldvalues = null;
        this.newvalues = null;
    }

    @Override
    public Object[] _currentValues() {
        Object[] result = new Object[12];
        result[0] = this.entryno;
        result[1] = this.entry_time;
        result[2] = this.userid;
        result[3] = this.sessionid;
        result[4] = this.grainid;
        result[5] = this.tablename;
        result[6] = this.action_type;
        result[7] = this.pkvalue1;
        result[8] = this.pkvalue2;
        result[9] = this.pkvalue3;
        result[10] = this.oldvalues;
        result[11] = this.newvalues;
        return result;
    }

    @Override
    protected void _setAutoIncrement(int val) {
        this.entryno = val;
    }

    public static void onPreDelete(ICelesta celesta, Consumer<? super LogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, LogCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta, Consumer<? super LogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, LogCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta, Consumer<? super LogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, LogCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta, Consumer<? super LogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, LogCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta, Consumer<? super LogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, LogCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta, Consumer<? super LogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, LogCursor.class, cursorConsumer);
    }

    @Override
    public LogCursor _getBufferCopy(CallContext context, List<String> fields) {
        final LogCursor result;
        if (Objects.isNull(fields)) {
            result = new LogCursor(context);
        }
        else {
            result = new LogCursor(context, new LinkedHashSet<>(fields));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        LogCursor from = (LogCursor)c;
        this.entryno = from.entryno;
        this.entry_time = from.entry_time;
        this.userid = from.userid;
        this.sessionid = from.sessionid;
        this.grainid = from.grainid;
        this.tablename = from.tablename;
        this.action_type = from.action_type;
        this.pkvalue1 = from.pkvalue1;
        this.pkvalue2 = from.pkvalue2;
        this.pkvalue3 = from.pkvalue3;
        this.oldvalues = from.oldvalues;
        this.newvalues = from.newvalues;
    }

    @Override
    public Iterator<LogCursor> iterator() {
        return new CursorIterator<LogCursor>(this);
    }

    @Override
    protected String _grainName() {
        return GRAIN_NAME;
    }

    @Override
    protected String _objectName() {
        return OBJECT_NAME;
    }

    @SuppressWarnings("unchecked")
    @Generated(
            value = "ru.curs.celesta.plugin.maven.CursorGenerator",
            date = "2020-03-01T00:38:06.99"
    )
    public static final class Columns {
        private final Table element;

        public Columns(ICelesta celesta) {
            this.element = celesta.getScore().getGrains().get(GRAIN_NAME).getElements(Table.class).get(OBJECT_NAME);
        }

        public ColumnMeta<Integer> entryno() {
            return (ColumnMeta<Integer>) this.element.getColumns().get("entryno");
        }

        public ColumnMeta<Date> entry_time() {
            return (ColumnMeta<Date>) this.element.getColumns().get("entry_time");
        }

        public ColumnMeta<String> userid() {
            return (ColumnMeta<String>) this.element.getColumns().get("userid");
        }

        public ColumnMeta<String> sessionid() {
            return (ColumnMeta<String>) this.element.getColumns().get("sessionid");
        }

        public ColumnMeta<String> grainid() {
            return (ColumnMeta<String>) this.element.getColumns().get("grainid");
        }

        public ColumnMeta<String> tablename() {
            return (ColumnMeta<String>) this.element.getColumns().get("tablename");
        }

        public ColumnMeta<String> action_type() {
            return (ColumnMeta<String>) this.element.getColumns().get("action_type");
        }

        public ColumnMeta<String> pkvalue1() {
            return (ColumnMeta<String>) this.element.getColumns().get("pkvalue1");
        }

        public ColumnMeta<String> pkvalue2() {
            return (ColumnMeta<String>) this.element.getColumns().get("pkvalue2");
        }

        public ColumnMeta<String> pkvalue3() {
            return (ColumnMeta<String>) this.element.getColumns().get("pkvalue3");
        }

        public ColumnMeta<String> oldvalues() {
            return (ColumnMeta<String>) this.element.getColumns().get("oldvalues");
        }

        public ColumnMeta<String> newvalues() {
            return (ColumnMeta<String>) this.element.getColumns().get("newvalues");
        }
    }
}
