package ru.curs.celesta.syscursors;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Generated;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.Table;

@Generated(
        value = "ru.curs.celesta.plugin.maven.CursorGenerator",
        date = "2020-03-01T00:38:06.996"
)
public final class SequencesCursor extends Cursor implements Iterable<SequencesCursor> {
    private static final String GRAIN_NAME = "celesta";

    private static final String OBJECT_NAME = "sequences";

    public static final String TABLE_NAME = OBJECT_NAME;

    public final SequencesCursor.Columns COLUMNS;

    private String grainid;

    private String tablename;

    private Integer seqvalue;

    {
        this.COLUMNS = new SequencesCursor.Columns(callContext().getCelesta());
    }

    public SequencesCursor(CallContext context) {
        super(context);
    }

    public SequencesCursor(CallContext context, ColumnMeta<?>... columns) {
        super(context, columns);
    }

    @Deprecated
    public SequencesCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public String getGrainid() {
        return this.grainid;
    }

    public void setGrainid(String grainid) {
        this.grainid = grainid;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public Integer getSeqvalue() {
        return this.seqvalue;
    }

    public void setSeqvalue(Integer seqvalue) {
        this.seqvalue = seqvalue;
    }

    @Override
    protected Object _getFieldValue(String name) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            return f.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            f.set(this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        Object[] result = new Object[2];
        result[0] = this.grainid;
        result[1] = this.tablename;
        return result;
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("grainid")) {
            this.grainid = rs.getString("grainid");
            if (rs.wasNull()) {
                this.grainid = null;
            }
        }
        if (this.inRec("tablename")) {
            this.tablename = rs.getString("tablename");
            if (rs.wasNull()) {
                this.tablename = null;
            }
        }
        if (this.inRec("seqvalue")) {
            this.seqvalue = rs.getInt("seqvalue");
            if (rs.wasNull()) {
                this.seqvalue = null;
            }
        }
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.grainid = null;
            this.tablename = null;
        }
        this.seqvalue = null;
    }

    @Override
    public Object[] _currentValues() {
        Object[] result = new Object[3];
        result[0] = this.grainid;
        result[1] = this.tablename;
        result[2] = this.seqvalue;
        return result;
    }

    @Override
    protected void _setAutoIncrement(int val) {
    }

    public static void onPreDelete(ICelesta celesta,
            Consumer<? super SequencesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, SequencesCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta,
            Consumer<? super SequencesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, SequencesCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta,
            Consumer<? super SequencesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, SequencesCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta,
            Consumer<? super SequencesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, SequencesCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta,
            Consumer<? super SequencesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, SequencesCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta,
            Consumer<? super SequencesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, SequencesCursor.class, cursorConsumer);
    }

    @Override
    public SequencesCursor _getBufferCopy(CallContext context, List<String> fields) {
        final SequencesCursor result;
        if (Objects.isNull(fields)) {
            result = new SequencesCursor(context);
        }
        else {
            result = new SequencesCursor(context, new LinkedHashSet<>(fields));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        SequencesCursor from = (SequencesCursor)c;
        this.grainid = from.grainid;
        this.tablename = from.tablename;
        this.seqvalue = from.seqvalue;
    }

    @Override
    public Iterator<SequencesCursor> iterator() {
        return new CursorIterator<SequencesCursor>(this);
    }

    @Override
    protected String _grainName() {
        return GRAIN_NAME;
    }

    @Override
    protected String _objectName() {
        return OBJECT_NAME;
    }

    @SuppressWarnings("unchecked")
    @Generated(
            value = "ru.curs.celesta.plugin.maven.CursorGenerator",
            date = "2020-03-01T00:38:06.997"
    )
    public static final class Columns {
        private final Table element;

        public Columns(ICelesta celesta) {
            this.element = celesta.getScore().getGrains().get(GRAIN_NAME).getElements(Table.class).get(OBJECT_NAME);
        }

        public ColumnMeta<String> grainid() {
            return (ColumnMeta<String>) this.element.getColumns().get("grainid");
        }

        public ColumnMeta<String> tablename() {
            return (ColumnMeta<String>) this.element.getColumns().get("tablename");
        }

        public ColumnMeta<Integer> seqvalue() {
            return (ColumnMeta<Integer>) this.element.getColumns().get("seqvalue");
        }
    }
}
