package ru.curs.celesta.syscursors;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.Table;

public final class RolesCursor extends Cursor implements Iterable<RolesCursor> {
    private static final String GRAIN_NAME = "celesta";

    private static final String OBJECT_NAME = "roles";

    public static final String TABLE_NAME = OBJECT_NAME;

    public final RolesCursor.Columns COLUMNS;

    private String id;

    private String description;

    {
        this.COLUMNS = new RolesCursor.Columns(callContext().getCelesta());
    }

    public RolesCursor(CallContext context) {
        super(context);
    }

    public RolesCursor(CallContext context, ColumnMeta<?>... columns) {
        super(context, columns);
    }

    @Deprecated
    public RolesCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    protected Object _getFieldValue(String name) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            return f.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            f.set(this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        Object[] result = new Object[1];
        result[0] = this.id;
        return result;
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("id")) {
            this.id = rs.getString("id");
            if (rs.wasNull()) {
                this.id = null;
            }
        }
        if (this.inRec("description")) {
            this.description = rs.getString("description");
            if (rs.wasNull()) {
                this.description = null;
            }
        }
        this.setRecversion(rs.getInt("recversion"));
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.id = null;
        }
        this.description = null;
    }

    @Override
    public Object[] _currentValues() {
        Object[] result = new Object[2];
        result[0] = this.id;
        result[1] = this.description;
        return result;
    }

    @Override
    protected void _setAutoIncrement(int val) {
    }

    public static void onPreDelete(ICelesta celesta, Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, RolesCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta,
            Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, RolesCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta, Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, RolesCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta,
            Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, RolesCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta, Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, RolesCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta,
            Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, RolesCursor.class, cursorConsumer);
    }

    @Override
    public RolesCursor _getBufferCopy(CallContext context, List<String> fields) {
        final RolesCursor result;
        if (Objects.isNull(fields)) {
            result = new RolesCursor(context);
        }
        else {
            result = new RolesCursor(context, new LinkedHashSet<>(fields));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        RolesCursor from = (RolesCursor)c;
        this.id = from.id;
        this.description = from.description;
        this.setRecversion(from.getRecversion());
    }

    @Override
    public Iterator<RolesCursor> iterator() {
        return new CursorIterator<RolesCursor>(this);
    }

    @Override
    protected String _grainName() {
        return GRAIN_NAME;
    }

    @Override
    protected String _objectName() {
        return OBJECT_NAME;
    }

    @SuppressWarnings("unchecked")
    public static final class Columns {
        private final Table element;

        public Columns(ICelesta celesta) {
            this.element = celesta.getScore().getGrains().get(GRAIN_NAME).getElements(Table.class).get(OBJECT_NAME);
        }

        public ColumnMeta<String> id() {
            return (ColumnMeta<String>) this.element.getColumns().get("id");
        }

        public ColumnMeta<String> description() {
            return (ColumnMeta<String>) this.element.getColumns().get("description");
        }
    }
}
