package ru.curs.celesta.syscursors;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Generated;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.Table;

@Generated(
        value = "ru.curs.celesta.plugin.maven.CursorGenerator",
        date = "2020-08-02T00:38:50.968"
)
public final class TablesCursor extends Cursor implements Iterable<TablesCursor> {
    private static final String GRAIN_NAME = "celesta";

    private static final String OBJECT_NAME = "tables";

    public static final String TABLE_NAME = OBJECT_NAME;

    public final TablesCursor.Columns COLUMNS;

    private String grainid;

    private String tablename;

    private String tabletype;

    private Boolean orphaned;

    {
        this.COLUMNS = new TablesCursor.Columns(callContext().getCelesta());
    }

    public TablesCursor(CallContext context) {
        super(context);
    }

    public TablesCursor(CallContext context, ColumnMeta<?>... columns) {
        super(context, columns);
    }

    @Deprecated
    public TablesCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public String getGrainid() {
        return this.grainid;
    }

    public void setGrainid(String grainid) {
        this.grainid = grainid;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTabletype() {
        return this.tabletype;
    }

    public void setTabletype(String tabletype) {
        this.tabletype = tabletype;
    }

    public Boolean getOrphaned() {
        return this.orphaned;
    }

    public void setOrphaned(Boolean orphaned) {
        this.orphaned = orphaned;
    }

    @Override
    protected Object _getFieldValue(String name) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            return f.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            f.set(this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        Object[] result = new Object[2];
        result[0] = this.grainid;
        result[1] = this.tablename;
        return result;
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("grainid")) {
            this.grainid = rs.getString("grainid");
            if (rs.wasNull()) {
                this.grainid = null;
            }
        }
        if (this.inRec("tablename")) {
            this.tablename = rs.getString("tablename");
            if (rs.wasNull()) {
                this.tablename = null;
            }
        }
        if (this.inRec("tabletype")) {
            this.tabletype = rs.getString("tabletype");
            if (rs.wasNull()) {
                this.tabletype = null;
            }
        }
        if (this.inRec("orphaned")) {
            this.orphaned = rs.getBoolean("orphaned");
            if (rs.wasNull()) {
                this.orphaned = null;
            }
        }
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.grainid = null;
            this.tablename = null;
        }
        this.tabletype = null;
        this.orphaned = null;
    }

    @Override
    public Object[] _currentValues() {
        Object[] result = new Object[4];
        result[0] = this.grainid;
        result[1] = this.tablename;
        result[2] = this.tabletype;
        result[3] = this.orphaned;
        return result;
    }

    @Override
    protected void _setAutoIncrement(int val) {
    }

    public static void onPreDelete(ICelesta celesta,
            Consumer<? super TablesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, TablesCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta,
            Consumer<? super TablesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, TablesCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta,
            Consumer<? super TablesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, TablesCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta,
            Consumer<? super TablesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, TablesCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta,
            Consumer<? super TablesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, TablesCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta,
            Consumer<? super TablesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, TablesCursor.class, cursorConsumer);
    }

    @Override
    public TablesCursor _getBufferCopy(CallContext context, List<String> fields) {
        final TablesCursor result;
        if (Objects.isNull(fields)) {
            result = new TablesCursor(context);
        }
        else {
            result = new TablesCursor(context, new LinkedHashSet<>(fields));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        TablesCursor from = (TablesCursor)c;
        this.grainid = from.grainid;
        this.tablename = from.tablename;
        this.tabletype = from.tabletype;
        this.orphaned = from.orphaned;
    }

    @Override
    public Iterator<TablesCursor> iterator() {
        return new CursorIterator<TablesCursor>(this);
    }

    @Override
    protected String _grainName() {
        return GRAIN_NAME;
    }

    @Override
    protected String _objectName() {
        return OBJECT_NAME;
    }

    @SuppressWarnings("unchecked")
    @Generated(
            value = "ru.curs.celesta.plugin.maven.CursorGenerator",
            date = "2020-08-02T00:38:50.969"
    )
    public static final class Columns {
        private final Table element;

        public Columns(ICelesta celesta) {
            this.element = celesta.getScore().getGrains().get(GRAIN_NAME).getElements(Table.class).get(OBJECT_NAME);
        }

        public ColumnMeta<String> grainid() {
            return (ColumnMeta<String>) this.element.getColumns().get("grainid");
        }

        public ColumnMeta<String> tablename() {
            return (ColumnMeta<String>) this.element.getColumns().get("tablename");
        }

        public ColumnMeta<String> tabletype() {
            return (ColumnMeta<String>) this.element.getColumns().get("tabletype");
        }

        public ColumnMeta<Boolean> orphaned() {
            return (ColumnMeta<Boolean>) this.element.getColumns().get("orphaned");
        }
    }
}
